/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.batch.sql;

import com.alibaba.alink.common.MLEnvironment;
import com.alibaba.alink.common.MLEnvironmentFactory;
import com.alibaba.alink.common.sql.builtin.AlinkRegisterBuiltinFunctions;
import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.params.sql.SqlCmdParams;
import java.util.HashSet;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.util.Preconditions;

public final class SqlCmdBatchOp
extends BatchOperator<SqlCmdBatchOp>
implements SqlCmdParams<SqlCmdBatchOp> {
    public static final Integer INPUT_NUM = 5;

    public SqlCmdBatchOp() {
        this(new Params());
    }

    public SqlCmdBatchOp(Params params) {
        super(params);
    }

    public SqlCmdBatchOp(String[] alias, String command) {
        this(new Params().set("alias", (Object)alias).set(COMMAND, (Object)command));
    }

    private boolean isDuplicated(String[] alias) {
        HashSet<String> nameSet = new HashSet<String>();
        for (String alia : alias) {
            if (alia != null && nameSet.contains(alia)) {
                return true;
            }
            nameSet.add(alia);
        }
        return false;
    }

    public SqlCmdBatchOp linkFrom(BatchOperator<?> ... inputs) {
        SqlCmdBatchOp.checkMinOpSize((int)1, inputs);
        if (this.getParams().contains("alias")) {
            String[] alias = this.getParams().getStringArray("alias");
            Preconditions.checkArgument((!this.isDuplicated(alias) ? 1 : 0) != 0, (Object)"Conflicting alias");
            long sessionId = this.getMLEnvironmentId();
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null || i >= alias.length || alias[i] == null || alias[i].isEmpty()) continue;
                inputs[i].registerTableName(alias[i]);
                if (sessionId == inputs[i].getMLEnvironmentId()) continue;
                sessionId = inputs[i].getMLEnvironmentId();
            }
            if (this.getMLEnvironmentId() != sessionId) {
                this.setMLEnvironmentId(sessionId);
            }
            MLEnvironment env = MLEnvironmentFactory.get((Long)sessionId);
            AlinkRegisterBuiltinFunctions.RegisterFunctions((TableEnvironment)env.getBatchTableEnvironment());
            this.setOutputTable(((BatchOperator)env.batchSQL(this.getCommand()).setMLEnvironmentId(Long.valueOf(sessionId))).getOutputTable());
            return this;
        }
        long sessionId = this.getMLEnvironmentId();
        String cmd = this.getCommand();
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            cmd = cmd.replace("${t" + i + "}", inputs[i].getTableName());
            if (sessionId == inputs[i].getMLEnvironmentId()) continue;
            sessionId = inputs[i].getMLEnvironmentId();
        }
        if (this.getMLEnvironmentId() != sessionId) {
            this.setMLEnvironmentId(sessionId);
        }
        MLEnvironment env = MLEnvironmentFactory.get((Long)sessionId);
        AlinkRegisterBuiltinFunctions.RegisterFunctions((TableEnvironment)env.getBatchTableEnvironment());
        this.setOutputTable(((BatchOperator)env.batchSQL(cmd).setMLEnvironmentId(Long.valueOf(sessionId))).getOutputTable());
        return this;
    }
}

