/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.sql.builtin.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.functions.AggregateFunction;

public class AggAsArray
extends AggregateFunction<Object[], Accumulator> {
    public Accumulator createAccumulator() {
        return new Accumulator();
    }

    public Object[] getValue(Accumulator acc) {
        return acc.objects.toArray(new Object[acc.objects.size()]);
    }

    public void accumulate(Accumulator acc, Object iValue) {
        acc.objects.add(iValue);
    }

    public void retract(Accumulator acc, Object iValue) {
        if (acc.objects.size() > 0) {
            acc.objects.remove(iValue);
        }
    }

    public void merge(Accumulator acc, Iterable<Accumulator> it) {
        for (Accumulator a : it) {
            acc.objects.addAll(a.objects);
        }
    }

    public void resetAccumulator(Accumulator acc) {
        acc.objects.clear();
    }

    public static class Accumulator
    implements Serializable {
        public List<Object> objects = new ArrayList<Object>();
    }
}

