# coding: utf-8

"""
    Marketing Events Extension

    These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.marketing.events.api_client import ApiClient
from hubspot.marketing.events.exceptions import ApiTypeError, ApiValueError


class MarketingEventsExternalApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """archive  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(external_event_id, external_account_id, **kwargs)  # noqa: E501

    def archive_with_http_info(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """archive  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "external_account_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `archive`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `archive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def archive_batch(self, batch_input_marketing_event_external_unique_identifier, **kwargs):  # noqa: E501
        """archive_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_batch(batch_input_marketing_event_external_unique_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputMarketingEventExternalUniqueIdentifier batch_input_marketing_event_external_unique_identifier: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Error
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_batch_with_http_info(batch_input_marketing_event_external_unique_identifier, **kwargs)  # noqa: E501

    def archive_batch_with_http_info(self, batch_input_marketing_event_external_unique_identifier, **kwargs):  # noqa: E501
        """archive_batch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_batch_with_http_info(batch_input_marketing_event_external_unique_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputMarketingEventExternalUniqueIdentifier batch_input_marketing_event_external_unique_identifier: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Error, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_marketing_event_external_unique_identifier"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive_batch" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_marketing_event_external_unique_identifier' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_external_unique_identifier" not in local_var_params or local_var_params["batch_input_marketing_event_external_unique_identifier"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_external_unique_identifier` when calling `archive_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_external_unique_identifier" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_external_unique_identifier"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/delete",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Error",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def complete(self, external_event_id, external_account_id, marketing_event_complete_request_params, **kwargs):  # noqa: E501
        """complete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete(external_event_id, external_account_id, marketing_event_complete_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param MarketingEventCompleteRequestParams marketing_event_complete_request_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.complete_with_http_info(external_event_id, external_account_id, marketing_event_complete_request_params, **kwargs)  # noqa: E501

    def complete_with_http_info(self, external_event_id, external_account_id, marketing_event_complete_request_params, **kwargs):  # noqa: E501
        """complete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_with_http_info(external_event_id, external_account_id, marketing_event_complete_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param MarketingEventCompleteRequestParams marketing_event_complete_request_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "external_account_id", "marketing_event_complete_request_params"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method complete" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `complete`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `complete`")  # noqa: E501
        # verify the required parameter 'marketing_event_complete_request_params' is set
        if self.api_client.client_side_validation and (
            "marketing_event_complete_request_params" not in local_var_params or local_var_params["marketing_event_complete_request_params"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `marketing_event_complete_request_params` when calling `complete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "marketing_event_complete_request_params" in local_var_params:
            body_params = local_var_params["marketing_event_complete_request_params"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}/complete",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create(self, marketing_event_create_request_params, **kwargs):  # noqa: E501
        """create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MarketingEventCreateRequestParams marketing_event_create_request_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_with_http_info(marketing_event_create_request_params, **kwargs)  # noqa: E501

    def create_with_http_info(self, marketing_event_create_request_params, **kwargs):  # noqa: E501
        """create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MarketingEventCreateRequestParams marketing_event_create_request_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["marketing_event_create_request_params"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method create" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'marketing_event_create_request_params' is set
        if self.api_client.client_side_validation and (
            "marketing_event_create_request_params" not in local_var_params or local_var_params["marketing_event_create_request_params"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `marketing_event_create_request_params` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "marketing_event_create_request_params" in local_var_params:
            body_params = local_var_params["marketing_event_create_request_params"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_cancel(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """do_cancel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_cancel(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_cancel_with_http_info(external_event_id, external_account_id, **kwargs)  # noqa: E501

    def do_cancel_with_http_info(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """do_cancel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_cancel_with_http_info(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "external_account_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_cancel" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `do_cancel`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `do_cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}/cancel",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_email_upsert_by_id(self, external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_email_subscriber, **kwargs):  # noqa: E501
        """do_email_upsert_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_email_upsert_by_id(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_email_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str subscriber_state: (required)
        :param str external_account_id: (required)
        :param BatchInputMarketingEventEmailSubscriber batch_input_marketing_event_email_subscriber: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Error
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_email_upsert_by_id_with_http_info(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_email_subscriber, **kwargs)  # noqa: E501

    def do_email_upsert_by_id_with_http_info(self, external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_email_subscriber, **kwargs):  # noqa: E501
        """do_email_upsert_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_email_upsert_by_id_with_http_info(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_email_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str subscriber_state: (required)
        :param str external_account_id: (required)
        :param BatchInputMarketingEventEmailSubscriber batch_input_marketing_event_email_subscriber: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Error, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "subscriber_state", "external_account_id", "batch_input_marketing_event_email_subscriber"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_email_upsert_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `do_email_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'subscriber_state' is set
        if self.api_client.client_side_validation and ("subscriber_state" not in local_var_params or local_var_params["subscriber_state"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscriber_state` when calling `do_email_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `do_email_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'batch_input_marketing_event_email_subscriber' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_email_subscriber" not in local_var_params or local_var_params["batch_input_marketing_event_email_subscriber"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_email_subscriber` when calling `do_email_upsert_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501
        if "subscriber_state" in local_var_params:
            path_params["subscriberState"] = local_var_params["subscriber_state"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_email_subscriber" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_email_subscriber"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/email-upsert",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Error",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_search(self, q, **kwargs):  # noqa: E501
        """do_search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search(q, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str q: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseMarketingEventExternalUniqueIdentifierNoPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_search_with_http_info(q, **kwargs)  # noqa: E501

    def do_search_with_http_info(self, q, **kwargs):  # noqa: E501
        """do_search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search_with_http_info(q, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str q: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseMarketingEventExternalUniqueIdentifierNoPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["q"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_search" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'q' is set
        if self.api_client.client_side_validation and ("q" not in local_var_params or local_var_params["q"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `q` when calling `do_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "q" in local_var_params and local_var_params["q"] is not None:  # noqa: E501
            query_params.append(("q", local_var_params["q"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/search",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseMarketingEventExternalUniqueIdentifierNoPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_upsert(self, batch_input_marketing_event_create_request_params, **kwargs):  # noqa: E501
        """do_upsert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_upsert(batch_input_marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputMarketingEventCreateRequestParams batch_input_marketing_event_create_request_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseMarketingEventPublicDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_upsert_with_http_info(batch_input_marketing_event_create_request_params, **kwargs)  # noqa: E501

    def do_upsert_with_http_info(self, batch_input_marketing_event_create_request_params, **kwargs):  # noqa: E501
        """do_upsert  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_upsert_with_http_info(batch_input_marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BatchInputMarketingEventCreateRequestParams batch_input_marketing_event_create_request_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseMarketingEventPublicDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["batch_input_marketing_event_create_request_params"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_upsert" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'batch_input_marketing_event_create_request_params' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_create_request_params" not in local_var_params or local_var_params["batch_input_marketing_event_create_request_params"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_create_request_params` when calling `do_upsert`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_create_request_params" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_create_request_params"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/upsert",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseMarketingEventPublicDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_upsert_by_id(self, external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_subscriber, **kwargs):  # noqa: E501
        """do_upsert_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_upsert_by_id(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str subscriber_state: (required)
        :param str external_account_id: (required)
        :param BatchInputMarketingEventSubscriber batch_input_marketing_event_subscriber: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Error
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_upsert_by_id_with_http_info(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_subscriber, **kwargs)  # noqa: E501

    def do_upsert_by_id_with_http_info(self, external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_subscriber, **kwargs):  # noqa: E501
        """do_upsert_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_upsert_by_id_with_http_info(external_event_id, subscriber_state, external_account_id, batch_input_marketing_event_subscriber, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str subscriber_state: (required)
        :param str external_account_id: (required)
        :param BatchInputMarketingEventSubscriber batch_input_marketing_event_subscriber: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Error, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "subscriber_state", "external_account_id", "batch_input_marketing_event_subscriber"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_upsert_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `do_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'subscriber_state' is set
        if self.api_client.client_side_validation and ("subscriber_state" not in local_var_params or local_var_params["subscriber_state"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `subscriber_state` when calling `do_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `do_upsert_by_id`")  # noqa: E501
        # verify the required parameter 'batch_input_marketing_event_subscriber' is set
        if self.api_client.client_side_validation and (
            "batch_input_marketing_event_subscriber" not in local_var_params or local_var_params["batch_input_marketing_event_subscriber"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_marketing_event_subscriber` when calling `do_upsert_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501
        if "subscriber_state" in local_var_params:
            path_params["subscriberState"] = local_var_params["subscriber_state"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_marketing_event_subscriber" in local_var_params:
            body_params = local_var_params["batch_input_marketing_event_subscriber"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/upsert",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Error",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventPublicReadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(external_event_id, external_account_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, external_event_id, external_account_id, **kwargs):  # noqa: E501
        """get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(external_event_id, external_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventPublicReadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "external_account_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `get_by_id`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventPublicReadResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def replace(self, external_event_id, marketing_event_create_request_params, **kwargs):  # noqa: E501
        """replace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace(external_event_id, marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param MarketingEventCreateRequestParams marketing_event_create_request_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventPublicDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.replace_with_http_info(external_event_id, marketing_event_create_request_params, **kwargs)  # noqa: E501

    def replace_with_http_info(self, external_event_id, marketing_event_create_request_params, **kwargs):  # noqa: E501
        """replace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_with_http_info(external_event_id, marketing_event_create_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param MarketingEventCreateRequestParams marketing_event_create_request_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventPublicDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "marketing_event_create_request_params"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method replace" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `replace`")  # noqa: E501
        # verify the required parameter 'marketing_event_create_request_params' is set
        if self.api_client.client_side_validation and (
            "marketing_event_create_request_params" not in local_var_params or local_var_params["marketing_event_create_request_params"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `marketing_event_create_request_params` when calling `replace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "marketing_event_create_request_params" in local_var_params:
            body_params = local_var_params["marketing_event_create_request_params"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventPublicDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update(self, external_event_id, external_account_id, marketing_event_update_request_params, **kwargs):  # noqa: E501
        """update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(external_event_id, external_account_id, marketing_event_update_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param MarketingEventUpdateRequestParams marketing_event_update_request_params: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MarketingEventPublicDefaultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_with_http_info(external_event_id, external_account_id, marketing_event_update_request_params, **kwargs)  # noqa: E501

    def update_with_http_info(self, external_event_id, external_account_id, marketing_event_update_request_params, **kwargs):  # noqa: E501
        """update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(external_event_id, external_account_id, marketing_event_update_request_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_event_id: (required)
        :param str external_account_id: (required)
        :param MarketingEventUpdateRequestParams marketing_event_update_request_params: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MarketingEventPublicDefaultResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["external_event_id", "external_account_id", "marketing_event_update_request_params"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method update" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'external_event_id' is set
        if self.api_client.client_side_validation and ("external_event_id" not in local_var_params or local_var_params["external_event_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_event_id` when calling `update`")  # noqa: E501
        # verify the required parameter 'external_account_id' is set
        if self.api_client.client_side_validation and ("external_account_id" not in local_var_params or local_var_params["external_account_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `external_account_id` when calling `update`")  # noqa: E501
        # verify the required parameter 'marketing_event_update_request_params' is set
        if self.api_client.client_side_validation and (
            "marketing_event_update_request_params" not in local_var_params or local_var_params["marketing_event_update_request_params"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `marketing_event_update_request_params` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "external_event_id" in local_var_params:
            path_params["externalEventId"] = local_var_params["external_event_id"]  # noqa: E501

        query_params = []
        if "external_account_id" in local_var_params and local_var_params["external_account_id"] is not None:  # noqa: E501
            query_params.append(("externalAccountId", local_var_params["external_account_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "marketing_event_update_request_params" in local_var_params:
            body_params = local_var_params["marketing_event_update_request_params"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/marketing/v3/marketing-events/events/{externalEventId}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="MarketingEventPublicDefaultResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
