# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.cms.hubdb.api_client import ApiClient
from hubspot.cms.hubdb.exceptions import ApiTypeError, ApiValueError


class RowsBatchApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def batch_clone_draft_table_rows(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Clone rows in batch  # noqa: E501

        Clones rows in the `draft` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_clone_draft_table_rows(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_clone_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, **kwargs)  # noqa: E501

    def batch_clone_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Clone rows in batch  # noqa: E501

        Clones rows in the `draft` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_clone_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_string"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_clone_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_clone_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and ("batch_input_string" not in local_var_params or local_var_params["batch_input_string"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_string` when calling `batch_clone_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_create_draft_table_rows(self, table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs):  # noqa: E501
        """Create rows in batch  # noqa: E501

        Creates rows in the `draft` version of the specified table, given an array of row objects. See the overview section for more details with an example.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_create_draft_table_rows(table_id_or_name, batch_input_hub_db_table_row_v3_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3Request batch_input_hub_db_table_row_v3_request: JSON array of row objects (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_create_draft_table_rows_with_http_info(table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs)  # noqa: E501

    def batch_create_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs):  # noqa: E501
        """Create rows in batch  # noqa: E501

        Creates rows in the `draft` version of the specified table, given an array of row objects. See the overview section for more details with an example.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_create_draft_table_rows_with_http_info(table_id_or_name, batch_input_hub_db_table_row_v3_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3Request batch_input_hub_db_table_row_v3_request: JSON array of row objects (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_hub_db_table_row_v3_request"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_create_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_create_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_hub_db_table_row_v3_request' is set
        if self.api_client.client_side_validation and (
            "batch_input_hub_db_table_row_v3_request" not in local_var_params or local_var_params["batch_input_hub_db_table_row_v3_request"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_hub_db_table_row_v3_request` when calling `batch_create_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_hub_db_table_row_v3_request" in local_var_params:
            body_params = local_var_params["batch_input_hub_db_table_row_v3_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/create",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_purge_draft_table_rows(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Permanently deletes rows  # noqa: E501

        Permanently deletes rows from the `draft` version of the table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_purge_draft_table_rows(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_purge_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, **kwargs)  # noqa: E501

    def batch_purge_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Permanently deletes rows  # noqa: E501

        Permanently deletes rows from the `draft` version of the table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_purge_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_string"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_purge_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_purge_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and ("batch_input_string" not in local_var_params or local_var_params["batch_input_string"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_string` when calling `batch_purge_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/purge",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_read_draft_table_rows(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Get a set of rows from draft table  # noqa: E501

        Returns rows in the `draft` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_draft_table_rows(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_read_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, **kwargs)  # noqa: E501

    def batch_read_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Get a set of rows from draft table  # noqa: E501

        Returns rows in the `draft` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_draft_table_rows_with_http_info(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_string"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_read_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_read_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and ("batch_input_string" not in local_var_params or local_var_params["batch_input_string"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_string` when calling `batch_read_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/read",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_read_table_rows(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Get a set of rows  # noqa: E501

        Returns rows in the `published` version of the specified table, given a set of row ids. **Note:** This endpoint can be accessed without any authentication if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_table_rows(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_read_table_rows_with_http_info(table_id_or_name, batch_input_string, **kwargs)  # noqa: E501

    def batch_read_table_rows_with_http_info(self, table_id_or_name, batch_input_string, **kwargs):  # noqa: E501
        """Get a set of rows  # noqa: E501

        Returns rows in the `published` version of the specified table, given a set of row ids. **Note:** This endpoint can be accessed without any authentication if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_table_rows_with_http_info(table_id_or_name, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to query. (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_string"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_read_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_read_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and ("batch_input_string" not in local_var_params or local_var_params["batch_input_string"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_string` when calling `batch_read_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/batch/read",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_replace_draft_table_rows(self, table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs):  # noqa: E501
        """Replace rows in batch in draft table  # noqa: E501

        Replaces multiple rows as a batch in the `draft` version of the table. See the endpoint `PUT /tables/{tableIdOrName}/rows/{rowId}/draft` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_replace_draft_table_rows(table_id_or_name, batch_input_hub_db_table_row_v3_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3Request batch_input_hub_db_table_row_v3_request: JSON array of row objects. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_replace_draft_table_rows_with_http_info(table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs)  # noqa: E501

    def batch_replace_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_hub_db_table_row_v3_request, **kwargs):  # noqa: E501
        """Replace rows in batch in draft table  # noqa: E501

        Replaces multiple rows as a batch in the `draft` version of the table. See the endpoint `PUT /tables/{tableIdOrName}/rows/{rowId}/draft` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_replace_draft_table_rows_with_http_info(table_id_or_name, batch_input_hub_db_table_row_v3_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3Request batch_input_hub_db_table_row_v3_request: JSON array of row objects. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_hub_db_table_row_v3_request"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_replace_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_replace_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_hub_db_table_row_v3_request' is set
        if self.api_client.client_side_validation and (
            "batch_input_hub_db_table_row_v3_request" not in local_var_params or local_var_params["batch_input_hub_db_table_row_v3_request"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_hub_db_table_row_v3_request` when calling `batch_replace_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_hub_db_table_row_v3_request" in local_var_params:
            body_params = local_var_params["batch_input_hub_db_table_row_v3_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/replace",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_update_draft_table_rows(self, table_id_or_name, batch_input_json_node, **kwargs):  # noqa: E501
        """Update rows in batch in draft table  # noqa: E501

        Updates multiple rows as a batch in the `draft` version of the table. See the endpoint `PATCH /tables/{tableIdOrName}/rows/{rowId}/draft` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_update_draft_table_rows(table_id_or_name, batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputJsonNode batch_input_json_node: JSON array of row objects. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchResponseHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_update_draft_table_rows_with_http_info(table_id_or_name, batch_input_json_node, **kwargs)  # noqa: E501

    def batch_update_draft_table_rows_with_http_info(self, table_id_or_name, batch_input_json_node, **kwargs):  # noqa: E501
        """Update rows in batch in draft table  # noqa: E501

        Updates multiple rows as a batch in the `draft` version of the table. See the endpoint `PATCH /tables/{tableIdOrName}/rows/{rowId}/draft` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_update_draft_table_rows_with_http_info(table_id_or_name, batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table (required)
        :param BatchInputJsonNode batch_input_json_node: JSON array of row objects. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchResponseHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "batch_input_json_node"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method batch_update_draft_table_rows" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and ("table_id_or_name" not in local_var_params or local_var_params["table_id_or_name"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `table_id_or_name` when calling `batch_update_draft_table_rows`")  # noqa: E501
        # verify the required parameter 'batch_input_json_node' is set
        if self.api_client.client_side_validation and ("batch_input_json_node" not in local_var_params or local_var_params["batch_input_json_node"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `batch_input_json_node` when calling `batch_update_draft_table_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params["table_id_or_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_json_node" in local_var_params:
            body_params = local_var_params["batch_input_json_node"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft/batch/update",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BatchResponseHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
