# generated by datamodel-codegen:
#   filename:  serviceProviderConfig.schema.json
#   timestamp: 2022-10-04T20:24:15+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Field


class Patch(BaseModel):
    supported: bool = Field(
        ...,
        description="A Boolean value specifying whether or not the operation is supported.",
    )


class Bulk(BaseModel):
    supported: bool = Field(
        ...,
        description="A Boolean value specifying whether or not the operation is supported.",
    )


class Filter(BaseModel):
    supported: bool = Field(
        ...,
        description="A Boolean value specifying whether or not the operation is supported.",
    )
    maxResults: Optional[int] = Field(
        None,
        description="A Boolean value specifying whether or not the operation is supported.",
    )


class ChangePassword(BaseModel):
    supported: bool = Field(
        ...,
        description="A Boolean value specifying whether or not the operation is supported.",
    )


class Sort(BaseModel):
    supported: bool = Field(
        ...,
        description="A Boolean value specifying whether or not the operation is supported.",
    )


class AuthenticationScheme(BaseModel):
    name: str = Field(
        ..., description="The common authentication scheme name, e.g., HTTP Basic."
    )
    description: str = Field(
        ..., description="A description of the authentication scheme."
    )
    specUri: Optional[AnyUrl] = Field(
        None,
        description="An HTTP-addressable URL pointing to the authentication scheme's specification.",
    )
    documentationUri: Optional[AnyUrl] = Field(
        None,
        description="An HTTP-addressable URL pointing to the authentication scheme's usage documentation.",
    )


class ServiceProviderConfiguration(BaseModel):
    documentationUri: Optional[AnyUrl] = Field(
        None,
        description="An HTTP-addressable URL pointing to the service provider's human-consumable help documentation.",
    )
    patch: Patch = Field(
        ..., description="A complex type that specifies PATCH configuration options."
    )
    bulk: Bulk = Field(
        ..., description="A complex type that specifies bulk configuration options."
    )
    filter: Filter = Field(
        ..., description="A complex type that specifies FILTER options."
    )
    changePassword: ChangePassword = Field(
        ...,
        description="A complex type that specifies configuration options related to changing a password.",
    )
    sort: Sort = Field(
        ..., description="A complex type that specifies sort result options."
    )
    authenticationSchemes: List[AuthenticationScheme] = Field(
        ...,
        description="A complex type that specifies supported authentication scheme properties.",
    )
