# coding: utf-8

"""
    IcoTest Voice

    IcoTest Voice API  # noqa: E501

    The version of the OpenAPI document: 1.0.31
    Contact: shaun.hirst@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from icotest_voice.configuration import Configuration


class Device(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'device_id': 'str',
        'serial_no': 'str',
        'device_type': 'str',
        'url': 'str',
        'created': 'datetime',
        'updated': 'datetime',
        'controller_id': 'str',
        'device_status': 'object',
        'callback_port': 'int',
        'management_status': 'bool',
        'last_contact': 'datetime'
    }

    attribute_map = {
        'device_id': 'device_id',
        'serial_no': 'serial_no',
        'device_type': 'device_type',
        'url': 'url',
        'created': 'created',
        'updated': 'updated',
        'controller_id': 'controller_id',
        'device_status': 'device_status',
        'callback_port': 'callback_port',
        'management_status': 'management_status',
        'last_contact': 'last_contact'
    }

    def __init__(self, device_id=None, serial_no=None, device_type=None, url=None, created=None, updated=None, controller_id=None, device_status=None, callback_port=None, management_status=None, last_contact=None, local_vars_configuration=None):  # noqa: E501
        """Device - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._device_id = None
        self._serial_no = None
        self._device_type = None
        self._url = None
        self._created = None
        self._updated = None
        self._controller_id = None
        self._device_status = None
        self._callback_port = None
        self._management_status = None
        self._last_contact = None
        self.discriminator = None

        if device_id is not None:
            self.device_id = device_id
        if serial_no is not None:
            self.serial_no = serial_no
        if device_type is not None:
            self.device_type = device_type
        if url is not None:
            self.url = url
        if created is not None:
            self.created = created
        if updated is not None:
            self.updated = updated
        if controller_id is not None:
            self.controller_id = controller_id
        if device_status is not None:
            self.device_status = device_status
        if callback_port is not None:
            self.callback_port = callback_port
        if management_status is not None:
            self.management_status = management_status
        if last_contact is not None:
            self.last_contact = last_contact

    @property
    def device_id(self):
        """Gets the device_id of this Device.  # noqa: E501

        the uuid of the device  # noqa: E501

        :return: The device_id of this Device.  # noqa: E501
        :rtype: str
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """Sets the device_id of this Device.

        the uuid of the device  # noqa: E501

        :param device_id: The device_id of this Device.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) > 36):
            raise ValueError("Invalid value for `device_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) < 36):
            raise ValueError("Invalid value for `device_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', device_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `device_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._device_id = device_id

    @property
    def serial_no(self):
        """Gets the serial_no of this Device.  # noqa: E501

        Serial number of the connected device  # noqa: E501

        :return: The serial_no of this Device.  # noqa: E501
        :rtype: str
        """
        return self._serial_no

    @serial_no.setter
    def serial_no(self, serial_no):
        """Sets the serial_no of this Device.

        Serial number of the connected device  # noqa: E501

        :param serial_no: The serial_no of this Device.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                serial_no is not None and len(serial_no) > 64):
            raise ValueError("Invalid value for `serial_no`, length must be less than or equal to `64`")  # noqa: E501

        self._serial_no = serial_no

    @property
    def device_type(self):
        """Gets the device_type of this Device.  # noqa: E501

        The type of device  # noqa: E501

        :return: The device_type of this Device.  # noqa: E501
        :rtype: str
        """
        return self._device_type

    @device_type.setter
    def device_type(self, device_type):
        """Sets the device_type of this Device.

        The type of device  # noqa: E501

        :param device_type: The device_type of this Device.  # noqa: E501
        :type: str
        """
        allowed_values = ["handset", "basestation", "sip", "unknown"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and device_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `device_type` ({0}), must be one of {1}"  # noqa: E501
                .format(device_type, allowed_values)
            )

        self._device_type = device_type

    @property
    def url(self):
        """Gets the url of this Device.  # noqa: E501

        The url of the device  # noqa: E501

        :return: The url of this Device.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Device.

        The url of the device  # noqa: E501

        :param url: The url of this Device.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                url is not None and len(url) > 256):
            raise ValueError("Invalid value for `url`, length must be less than or equal to `256`")  # noqa: E501

        self._url = url

    @property
    def created(self):
        """Gets the created of this Device.  # noqa: E501

        The date time the device was added  # noqa: E501

        :return: The created of this Device.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Device.

        The date time the device was added  # noqa: E501

        :param created: The created of this Device.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def updated(self):
        """Gets the updated of this Device.  # noqa: E501

        The date time the device was last updated  # noqa: E501

        :return: The updated of this Device.  # noqa: E501
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """Sets the updated of this Device.

        The date time the device was last updated  # noqa: E501

        :param updated: The updated of this Device.  # noqa: E501
        :type: datetime
        """

        self._updated = updated

    @property
    def controller_id(self):
        """Gets the controller_id of this Device.  # noqa: E501

        The controller id that manages the device  # noqa: E501

        :return: The controller_id of this Device.  # noqa: E501
        :rtype: str
        """
        return self._controller_id

    @controller_id.setter
    def controller_id(self, controller_id):
        """Sets the controller_id of this Device.

        The controller id that manages the device  # noqa: E501

        :param controller_id: The controller_id of this Device.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and len(controller_id) > 36):
            raise ValueError("Invalid value for `controller_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and len(controller_id) < 36):
            raise ValueError("Invalid value for `controller_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                controller_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', controller_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `controller_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._controller_id = controller_id

    @property
    def device_status(self):
        """Gets the device_status of this Device.  # noqa: E501

        Model of device status  # noqa: E501

        :return: The device_status of this Device.  # noqa: E501
        :rtype: object
        """
        return self._device_status

    @device_status.setter
    def device_status(self, device_status):
        """Sets the device_status of this Device.

        Model of device status  # noqa: E501

        :param device_status: The device_status of this Device.  # noqa: E501
        :type: object
        """

        self._device_status = device_status

    @property
    def callback_port(self):
        """Gets the callback_port of this Device.  # noqa: E501

        The call back port number  # noqa: E501

        :return: The callback_port of this Device.  # noqa: E501
        :rtype: int
        """
        return self._callback_port

    @callback_port.setter
    def callback_port(self, callback_port):
        """Sets the callback_port of this Device.

        The call back port number  # noqa: E501

        :param callback_port: The callback_port of this Device.  # noqa: E501
        :type: int
        """

        self._callback_port = callback_port

    @property
    def management_status(self):
        """Gets the management_status of this Device.  # noqa: E501

        Management status, if True we run process  # noqa: E501

        :return: The management_status of this Device.  # noqa: E501
        :rtype: bool
        """
        return self._management_status

    @management_status.setter
    def management_status(self, management_status):
        """Sets the management_status of this Device.

        Management status, if True we run process  # noqa: E501

        :param management_status: The management_status of this Device.  # noqa: E501
        :type: bool
        """

        self._management_status = management_status

    @property
    def last_contact(self):
        """Gets the last_contact of this Device.  # noqa: E501

        The last contact date time with the controller  # noqa: E501

        :return: The last_contact of this Device.  # noqa: E501
        :rtype: datetime
        """
        return self._last_contact

    @last_contact.setter
    def last_contact(self, last_contact):
        """Sets the last_contact of this Device.

        The last contact date time with the controller  # noqa: E501

        :param last_contact: The last_contact of this Device.  # noqa: E501
        :type: datetime
        """

        self._last_contact = last_contact

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Device):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Device):
            return True

        return self.to_dict() != other.to_dict()
