# coding: utf-8

"""
    IcoTest Voice

    IcoTest Voice API  # noqa: E501

    The version of the OpenAPI document: 1.0.31
    Contact: shaun.hirst@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from icotest_voice.api_client import ApiClient
from icotest_voice.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DevicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_device(self, device_id, **kwargs):  # noqa: E501
        """DELETE Device  # noqa: E501

        Delete an existing device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of a device (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_device_with_http_info(device_id, **kwargs)  # noqa: E501

    def delete_device_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """DELETE Device  # noqa: E501

        Delete an existing device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of a device (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `delete_device`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `delete_device`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `delete_device`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `delete_device`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'device_id' in local_var_params and local_var_params['device_id'] is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices(self, **kwargs):  # noqa: E501
        """GET devices  # noqa: E501

        Get a list of available devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller
        :param str device_id: the unique id of the device
        :param str device_type: type of device
        :param str serial_no: serial number
        :param bool management_status: management status
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Device]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_with_http_info(**kwargs)  # noqa: E501

    def get_devices_with_http_info(self, **kwargs):  # noqa: E501
        """GET devices  # noqa: E501

        Get a list of available devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller
        :param str device_id: the unique id of the device
        :param str device_type: type of device
        :param str serial_no: serial number
        :param bool management_status: management status
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Device], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id',
            'device_id',
            'device_type',
            'serial_no',
            'management_status'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_devices`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_devices`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `get_devices`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial_no' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial_no']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial_no` when calling `get_devices`, length must be less than or equal to `64`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'controller_id' in local_var_params and local_var_params['controller_id'] is not None:  # noqa: E501
            query_params.append(('controller_id', local_var_params['controller_id']))  # noqa: E501
        if 'device_id' in local_var_params and local_var_params['device_id'] is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501
        if 'device_type' in local_var_params and local_var_params['device_type'] is not None:  # noqa: E501
            query_params.append(('device_type', local_var_params['device_type']))  # noqa: E501
        if 'serial_no' in local_var_params and local_var_params['serial_no'] is not None:  # noqa: E501
            query_params.append(('serial_no', local_var_params['serial_no']))  # noqa: E501
        if 'management_status' in local_var_params and local_var_params['management_status'] is not None:  # noqa: E501
            query_params.append(('management_status', local_var_params['management_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Device]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_status(self, device_id, **kwargs):  # noqa: E501
        """GET device status  # noqa: E501

        Get device status within a certain time offset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_status(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int valid_time_offset: the valid time offset for the request
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_status_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_devices_status_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET device status  # noqa: E501

        Get device status within a certain time offset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_status_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int valid_time_offset: the valid time offset for the request
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'valid_time_offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'valid_time_offset' in local_var_params and local_var_params['valid_time_offset'] is not None:  # noqa: E501
            query_params.append(('valid_time_offset', local_var_params['valid_time_offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_config(self, **kwargs):  # noqa: E501
        """Your GET endpoint  # noqa: E501

        get configuration of host (IP address, name, etc.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HostConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_host_config_with_http_info(**kwargs)  # noqa: E501

    def get_host_config_with_http_info(self, **kwargs):  # noqa: E501
        """Your GET endpoint  # noqa: E501

        get configuration of host (IP address, name, etc.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HostConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/host/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_device_deregister(self, device_id, **kwargs):  # noqa: E501
        """POST deregister device  # noqa: E501

        Post request to perform a device deregister from base station  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_deregister(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_device_deregister_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_device_deregister_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST deregister device  # noqa: E501

        Post request to perform a device deregister from base station  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_deregister_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_device_deregister" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_device_deregister`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_device_deregister`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/deregister', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_device_make_call(self, device_id, call_type, phone_number, **kwargs):  # noqa: E501
        """POST make call  # noqa: E501

        Post request to make an internal or external call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_make_call(device_id, call_type, phone_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str call_type: internal or external call (required)
        :param str phone_number: the number to call (required)
        :param int call_duration: the duration of the call in seconds (0 is unlimited)
        :param str outgoing_recording_file: the filename of the recorded call
        :param str playback_file: the filename of the playback file
        :param bool playback_loop: whether to play the playback file in a loop
        :param int wait_time: the duration of the wait time in seconds for the callee to respond
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_device_make_call_with_http_info(device_id, call_type, phone_number, **kwargs)  # noqa: E501

    def post_device_make_call_with_http_info(self, device_id, call_type, phone_number, **kwargs):  # noqa: E501
        """POST make call  # noqa: E501

        Post request to make an internal or external call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_make_call_with_http_info(device_id, call_type, phone_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str call_type: internal or external call (required)
        :param str phone_number: the number to call (required)
        :param int call_duration: the duration of the call in seconds (0 is unlimited)
        :param str outgoing_recording_file: the filename of the recorded call
        :param str playback_file: the filename of the playback file
        :param bool playback_loop: whether to play the playback file in a loop
        :param int wait_time: the duration of the wait time in seconds for the callee to respond
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'call_type',
            'phone_number',
            'call_duration',
            'outgoing_recording_file',
            'playback_file',
            'playback_loop',
            'wait_time'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_device_make_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_device_make_call`")  # noqa: E501
        # verify the required parameter 'call_type' is set
        if self.api_client.client_side_validation and ('call_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_type` when calling `post_device_make_call`")  # noqa: E501
        # verify the required parameter 'phone_number' is set
        if self.api_client.client_side_validation and ('phone_number' not in local_var_params or  # noqa: E501
                                                        local_var_params['phone_number'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `phone_number` when calling `post_device_make_call`")  # noqa: E501

        if self.api_client.client_side_validation and ('phone_number' in local_var_params and  # noqa: E501
                                                        len(local_var_params['phone_number']) > 40):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `phone_number` when calling `post_device_make_call`, length must be less than or equal to `40`")  # noqa: E501
        if self.api_client.client_side_validation and 'call_duration' in local_var_params and local_var_params['call_duration'] > 65535:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `call_duration` when calling `post_device_make_call`, must be a value less than or equal to `65535`")  # noqa: E501
        if self.api_client.client_side_validation and 'call_duration' in local_var_params and local_var_params['call_duration'] <= 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `call_duration` when calling `post_device_make_call`, must be a value greater than `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'wait_time' in local_var_params and local_var_params['wait_time'] <= 5:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `wait_time` when calling `post_device_make_call`, must be a value greater than `5`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'call_type' in local_var_params and local_var_params['call_type'] is not None:  # noqa: E501
            query_params.append(('call_type', local_var_params['call_type']))  # noqa: E501
        if 'phone_number' in local_var_params and local_var_params['phone_number'] is not None:  # noqa: E501
            query_params.append(('phone_number', local_var_params['phone_number']))  # noqa: E501
        if 'call_duration' in local_var_params and local_var_params['call_duration'] is not None:  # noqa: E501
            query_params.append(('call_duration', local_var_params['call_duration']))  # noqa: E501
        if 'outgoing_recording_file' in local_var_params and local_var_params['outgoing_recording_file'] is not None:  # noqa: E501
            query_params.append(('outgoing_recording_file', local_var_params['outgoing_recording_file']))  # noqa: E501
        if 'playback_file' in local_var_params and local_var_params['playback_file'] is not None:  # noqa: E501
            query_params.append(('playback_file', local_var_params['playback_file']))  # noqa: E501
        if 'playback_loop' in local_var_params and local_var_params['playback_loop'] is not None:  # noqa: E501
            query_params.append(('playback_loop', local_var_params['playback_loop']))  # noqa: E501
        if 'wait_time' in local_var_params and local_var_params['wait_time'] is not None:  # noqa: E501
            query_params.append(('wait_time', local_var_params['wait_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/make_call', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_device_register(self, device_id, **kwargs):  # noqa: E501
        """POST register device  # noqa: E501

        Post request to perform a device register to base station  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_register(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int channel_number: the number of the channel
        :param str pin_code: the 4 to 8-digit PIN code
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_device_register_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_device_register_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST register device  # noqa: E501

        Post request to perform a device register to base station  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_device_register_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int channel_number: the number of the channel
        :param str pin_code: the 4 to 8-digit PIN code
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'channel_number',
            'pin_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_device_register" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_device_register`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_device_register`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_device_register`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_device_register`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('channel_number' in local_var_params and  # noqa: E501
                                                        len(local_var_params['channel_number']) > 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_number` when calling `post_device_register`, length must be less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('channel_number' in local_var_params and  # noqa: E501
                                                        len(local_var_params['channel_number']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_number` when calling `post_device_register`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'channel_number' in local_var_params and local_var_params['channel_number'] > 9:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_number` when calling `post_device_register`, must be a value less than or equal to `9`")  # noqa: E501
        if self.api_client.client_side_validation and 'channel_number' in local_var_params and local_var_params['channel_number'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_number` when calling `post_device_register`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'channel_number' in local_var_params and not re.search(r'[0-9]', local_var_params['channel_number']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_number` when calling `post_device_register`, must conform to the pattern `/[0-9]/`")  # noqa: E501
        if self.api_client.client_side_validation and ('pin_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['pin_code']) > 8):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `pin_code` when calling `post_device_register`, length must be less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and ('pin_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['pin_code']) < 4):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `pin_code` when calling `post_device_register`, length must be greater than or equal to `4`")  # noqa: E501
        if self.api_client.client_side_validation and 'pin_code' in local_var_params and not re.search(r'^\d{4,8}$', local_var_params['pin_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `pin_code` when calling `post_device_register`, must conform to the pattern `/^\d{4,8}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'channel_number' in local_var_params and local_var_params['channel_number'] is not None:  # noqa: E501
            query_params.append(('channel_number', local_var_params['channel_number']))  # noqa: E501
        if 'pin_code' in local_var_params and local_var_params['pin_code'] is not None:  # noqa: E501
            query_params.append(('pin_code', local_var_params['pin_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/register', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_devices_end_call(self, device_id, **kwargs):  # noqa: E501
        """POST end call  # noqa: E501

        Post request to end a call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_end_call(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str reason: reason for ending call
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_devices_end_call_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_devices_end_call_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST end call  # noqa: E501

        Post request to end a call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_end_call_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str reason: reason for ending call
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'reason'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_devices_end_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_devices_end_call`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_end_call`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_end_call`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_end_call`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'reason' in local_var_params and local_var_params['reason'] is not None:  # noqa: E501
            query_params.append(('reason', local_var_params['reason']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/end_call', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_devices_heartbeat(self, device_id, **kwargs):  # noqa: E501
        """POST Device heartbeat  # noqa: E501

        Device heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_heartbeat(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_devices_heartbeat_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_devices_heartbeat_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST Device heartbeat  # noqa: E501

        Device heartbeat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_heartbeat_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_devices_heartbeat" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_devices_heartbeat`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_heartbeat`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_heartbeat`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_heartbeat`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/heartbeat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_devices_receive_call(self, device_id, **kwargs):  # noqa: E501
        """POST receive call  # noqa: E501

        Post request to receive a call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_receive_call(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int ring_count: number of rings before call is picked up
        :param int call_duration: the duration of the call in seconds (0 is unlimited)
        :param str incoming_recording_file: the filename of the recorded call
        :param str playback_file: the filename of the playback file
        :param bool playback_loop: whether to play the playback file in a loop
        :param int wait_time: the duration of the wait time in seconds for the caller to make a call
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_devices_receive_call_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_devices_receive_call_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST receive call  # noqa: E501

        Post request to receive a call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_receive_call_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param int ring_count: number of rings before call is picked up
        :param int call_duration: the duration of the call in seconds (0 is unlimited)
        :param str incoming_recording_file: the filename of the recorded call
        :param str playback_file: the filename of the playback file
        :param bool playback_loop: whether to play the playback file in a loop
        :param int wait_time: the duration of the wait time in seconds for the caller to make a call
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'ring_count',
            'call_duration',
            'incoming_recording_file',
            'playback_file',
            'playback_loop',
            'wait_time'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_devices_receive_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_devices_receive_call`")  # noqa: E501

        if self.api_client.client_side_validation and 'ring_count' in local_var_params and local_var_params['ring_count'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `ring_count` when calling `post_devices_receive_call`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'ring_count' in local_var_params and local_var_params['ring_count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `ring_count` when calling `post_devices_receive_call`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'call_duration' in local_var_params and local_var_params['call_duration'] > 65535:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `call_duration` when calling `post_devices_receive_call`, must be a value less than or equal to `65535`")  # noqa: E501
        if self.api_client.client_side_validation and 'call_duration' in local_var_params and local_var_params['call_duration'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `call_duration` when calling `post_devices_receive_call`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'wait_time' in local_var_params and local_var_params['wait_time'] <= 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `wait_time` when calling `post_devices_receive_call`, must be a value greater than `10`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'ring_count' in local_var_params and local_var_params['ring_count'] is not None:  # noqa: E501
            query_params.append(('ring_count', local_var_params['ring_count']))  # noqa: E501
        if 'call_duration' in local_var_params and local_var_params['call_duration'] is not None:  # noqa: E501
            query_params.append(('call_duration', local_var_params['call_duration']))  # noqa: E501
        if 'incoming_recording_file' in local_var_params and local_var_params['incoming_recording_file'] is not None:  # noqa: E501
            query_params.append(('incoming_recording_file', local_var_params['incoming_recording_file']))  # noqa: E501
        if 'playback_file' in local_var_params and local_var_params['playback_file'] is not None:  # noqa: E501
            query_params.append(('playback_file', local_var_params['playback_file']))  # noqa: E501
        if 'playback_loop' in local_var_params and local_var_params['playback_loop'] is not None:  # noqa: E501
            query_params.append(('playback_loop', local_var_params['playback_loop']))  # noqa: E501
        if 'wait_time' in local_var_params and local_var_params['wait_time'] is not None:  # noqa: E501
            query_params.append(('wait_time', local_var_params['wait_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/receive_call', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_devices_scan(self, controller_id, **kwargs):  # noqa: E501
        """POST device scan  # noqa: E501

        Scan to discover new devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_scan(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_devices_scan_with_http_info(controller_id, **kwargs)  # noqa: E501

    def post_devices_scan_with_http_info(self, controller_id, **kwargs):  # noqa: E501
        """POST device scan  # noqa: E501

        Scan to discover new devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_scan_with_http_info(controller_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str controller_id: the unique id of the controller (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'controller_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_devices_scan" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'controller_id' is set
        if self.api_client.client_side_validation and ('controller_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['controller_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `controller_id` when calling `post_devices_scan`")  # noqa: E501

        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_devices_scan`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('controller_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['controller_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_devices_scan`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'controller_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['controller_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `controller_id` when calling `post_devices_scan`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'controller_id' in local_var_params:
            path_params['controller_id'] = local_var_params['controller_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{controller_id}/scan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_devices_send_command(self, device_id, **kwargs):  # noqa: E501
        """POST send command  # noqa: E501

        Post request to send a command to device. This will be sent as numbers during an external call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_send_command(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str command: command to send
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_devices_send_command_with_http_info(device_id, **kwargs)  # noqa: E501

    def post_devices_send_command_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """POST send command  # noqa: E501

        Post request to send a command to device. This will be sent as numbers during an external call  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_devices_send_command_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param str command: command to send
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'command'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_devices_send_command" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `post_devices_send_command`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_send_command`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_send_command`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `post_devices_send_command`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('command' in local_var_params and  # noqa: E501
                                                        len(local_var_params['command']) > 128):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `command` when calling `post_devices_send_command`, length must be less than or equal to `128`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'command' in local_var_params and local_var_params['command'] is not None:  # noqa: E501
            query_params.append(('command', local_var_params['command']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/send_command', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_device(self, **kwargs):  # noqa: E501
        """PUT device  # noqa: E501

        Add or update a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_device(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Device device: the model of a device
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_with_http_info(**kwargs)  # noqa: E501

    def put_device_with_http_info(self, **kwargs):  # noqa: E501
        """PUT device  # noqa: E501

        Add or update a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_device_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Device device: the model of a device
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'device' in local_var_params:
            body_params = local_var_params['device']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_devices_status(self, device_id, **kwargs):  # noqa: E501
        """PUT device status  # noqa: E501

        Put device status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_status(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param object body: The model of a device
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_status_with_http_info(device_id, **kwargs)  # noqa: E501

    def put_devices_status_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """PUT device status  # noqa: E501

        Put device status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_status_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: the unique id of the device (required)
        :param object body: The model of a device
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/devices/{device_id}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_host_config(self, **kwargs):  # noqa: E501
        """put_host_config  # noqa: E501

        put a host configuration (IP address, name, etc.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_host_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HostConfig host_config:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_host_config_with_http_info(**kwargs)  # noqa: E501

    def put_host_config_with_http_info(self, **kwargs):  # noqa: E501
        """put_host_config  # noqa: E501

        put a host configuration (IP address, name, etc.)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_host_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HostConfig host_config:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'host_config'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_host_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_config' in local_var_params:
            body_params = local_var_params['host_config']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/host/config', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
