"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductTopic = exports.ProductTopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "ProductTopicProperty", { enumerable: true, get: function () { return iot_generated_1.RosProductTopic; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::ProductTopic`
 */
class ProductTopic extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::ProductTopic`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosProductTopic = new iot_generated_1.RosProductTopic(this, id, {
            desc: props.desc,
            iotInstanceId: props.iotInstanceId,
            topicShortName: props.topicShortName,
            operation: props.operation,
            productKey: props.productKey,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProductTopic;
        this.attrTopicId = rosProductTopic.attrTopicId;
    }
}
exports.ProductTopic = ProductTopic;
//# sourceMappingURL=data:application/json;base64,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