"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRuleAction = exports.RosRule = exports.RosProductTopic = exports.RosProduct = exports.RosDeviceGroup = exports.RosDevice = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosDeviceProps`
 *
 * @param properties - the TypeScript properties of a `RosDeviceProps`
 *
 * @returns the result of the validation.
 */
function RosDevicePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('devEui', ros.validateString)(properties.devEui));
    errors.collect(ros.propertyValidator('productKey', ros.requiredValidator)(properties.productKey));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    errors.collect(ros.propertyValidator('deviceName', ros.validateString)(properties.deviceName));
    errors.collect(ros.propertyValidator('pinCode', ros.validateString)(properties.pinCode));
    errors.collect(ros.propertyValidator('nickname', ros.validateString)(properties.nickname));
    return errors.wrap('supplied properties not correct for "RosDeviceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Device` resource
 *
 * @param properties - the TypeScript properties of a `RosDeviceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Device` resource.
 */
// @ts-ignore TS6133
function rosDevicePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDevicePropsValidator(properties).assertSuccess();
    }
    return {
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        DevEui: ros.stringToRosTemplate(properties.devEui),
        DeviceName: ros.stringToRosTemplate(properties.deviceName),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        Nickname: ros.stringToRosTemplate(properties.nickname),
        PinCode: ros.stringToRosTemplate(properties.pinCode),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Device`
 */
class RosDevice extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Device`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDevice.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDeviceName = this.getAtt('DeviceName');
        this.attrDeviceSecret = this.getAtt('DeviceSecret');
        this.attrIotId = this.getAtt('IotId');
        this.attrIotInstanceId = this.getAtt('IotInstanceId');
        this.attrIpAddress = this.getAtt('IpAddress');
        this.attrNickName = this.getAtt('NickName');
        this.attrNodeType = this.getAtt('NodeType');
        this.attrProductKey = this.getAtt('ProductKey');
        this.attrProductName = this.getAtt('ProductName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.productKey = props.productKey;
        this.devEui = props.devEui;
        this.deviceName = props.deviceName;
        this.iotInstanceId = props.iotInstanceId;
        this.nickname = props.nickname;
        this.pinCode = props.pinCode;
    }
    get rosProperties() {
        return {
            productKey: this.productKey,
            devEui: this.devEui,
            deviceName: this.deviceName,
            iotInstanceId: this.iotInstanceId,
            nickname: this.nickname,
            pinCode: this.pinCode,
        };
    }
    renderProperties(props) {
        return rosDevicePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDevice = RosDevice;
/**
 * The resource type name for this resource class.
 */
RosDevice.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Device";
/**
 * Determine whether the given properties match those of a `RosDeviceGroupProps`
 *
 * @param properties - the TypeScript properties of a `RosDeviceGroupProps`
 *
 * @returns the result of the validation.
 */
function RosDeviceGroupPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('groupName', ros.requiredValidator)(properties.groupName));
    errors.collect(ros.propertyValidator('groupName', ros.validateString)(properties.groupName));
    errors.collect(ros.propertyValidator('superGroupId', ros.validateString)(properties.superGroupId));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('groupDesc', ros.validateString)(properties.groupDesc));
    return errors.wrap('supplied properties not correct for "RosDeviceGroupProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::DeviceGroup` resource
 *
 * @param properties - the TypeScript properties of a `RosDeviceGroupProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::DeviceGroup` resource.
 */
// @ts-ignore TS6133
function rosDeviceGroupPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDeviceGroupPropsValidator(properties).assertSuccess();
    }
    return {
        GroupName: ros.stringToRosTemplate(properties.groupName),
        GroupDesc: ros.stringToRosTemplate(properties.groupDesc),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        SuperGroupId: ros.stringToRosTemplate(properties.superGroupId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::DeviceGroup`
 */
class RosDeviceGroup extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::DeviceGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDeviceGroup.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrGroupId = this.getAtt('GroupId');
        this.attrIotInstanceId = this.getAtt('IotInstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.groupName = props.groupName;
        this.groupDesc = props.groupDesc;
        this.iotInstanceId = props.iotInstanceId;
        this.superGroupId = props.superGroupId;
    }
    get rosProperties() {
        return {
            groupName: this.groupName,
            groupDesc: this.groupDesc,
            iotInstanceId: this.iotInstanceId,
            superGroupId: this.superGroupId,
        };
    }
    renderProperties(props) {
        return rosDeviceGroupPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDeviceGroup = RosDeviceGroup;
/**
 * The resource type name for this resource class.
 */
RosDeviceGroup.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::DeviceGroup";
/**
 * Determine whether the given properties match those of a `RosProductProps`
 *
 * @param properties - the TypeScript properties of a `RosProductProps`
 *
 * @returns the result of the validation.
 */
function RosProductPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('publishAuto', ros.validateBoolean)(properties.publishAuto));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('productName', ros.requiredValidator)(properties.productName));
    errors.collect(ros.propertyValidator('productName', ros.validateString)(properties.productName));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('aliyunCommodityCode', ros.validateString)(properties.aliyunCommodityCode));
    errors.collect(ros.propertyValidator('categoryKey', ros.validateString)(properties.categoryKey));
    if (properties.protocolType && (typeof properties.protocolType) !== 'object') {
        errors.collect(ros.propertyValidator('protocolType', ros.validateAllowedValues)({
            data: properties.protocolType,
            allowedValues: ["ble", "customize", "modbus", "opc-ua", "zigbee"],
        }));
    }
    errors.collect(ros.propertyValidator('protocolType', ros.validateString)(properties.protocolType));
    errors.collect(ros.propertyValidator('id2', ros.validateBoolean)(properties.id2));
    errors.collect(ros.propertyValidator('nodeType', ros.requiredValidator)(properties.nodeType));
    if (properties.nodeType && (typeof properties.nodeType) !== 'object') {
        errors.collect(ros.propertyValidator('nodeType', ros.validateAllowedValues)({
            data: properties.nodeType,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('nodeType', ros.validateNumber)(properties.nodeType));
    if (properties.dataFormat && (typeof properties.dataFormat) !== 'object') {
        errors.collect(ros.propertyValidator('dataFormat', ros.validateAllowedValues)({
            data: properties.dataFormat,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('dataFormat', ros.validateNumber)(properties.dataFormat));
    errors.collect(ros.propertyValidator('authType', ros.validateString)(properties.authType));
    errors.collect(ros.propertyValidator('joinPermissionId', ros.validateString)(properties.joinPermissionId));
    if (properties.netType && (typeof properties.netType) !== 'object') {
        errors.collect(ros.propertyValidator('netType', ros.validateAllowedValues)({
            data: properties.netType,
            allowedValues: ["CELLULAR", "ETHERNET", "LORA", "OTHER", "WIFI"],
        }));
    }
    errors.collect(ros.propertyValidator('netType', ros.validateString)(properties.netType));
    return errors.wrap('supplied properties not correct for "RosProductProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Product` resource
 *
 * @param properties - the TypeScript properties of a `RosProductProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Product` resource.
 */
// @ts-ignore TS6133
function rosProductPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProductPropsValidator(properties).assertSuccess();
    }
    return {
        NodeType: ros.numberToRosTemplate(properties.nodeType),
        ProductName: ros.stringToRosTemplate(properties.productName),
        AliyunCommodityCode: ros.stringToRosTemplate(properties.aliyunCommodityCode),
        AuthType: ros.stringToRosTemplate(properties.authType),
        CategoryKey: ros.stringToRosTemplate(properties.categoryKey),
        DataFormat: ros.numberToRosTemplate(properties.dataFormat),
        Description: ros.stringToRosTemplate(properties.description),
        Id2: ros.booleanToRosTemplate(properties.id2),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        JoinPermissionId: ros.stringToRosTemplate(properties.joinPermissionId),
        NetType: ros.stringToRosTemplate(properties.netType),
        ProtocolType: ros.stringToRosTemplate(properties.protocolType),
        PublishAuto: ros.booleanToRosTemplate(properties.publishAuto),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Product`
 */
class RosProduct extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Product`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProduct.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrIotInstanceId = this.getAtt('IotInstanceId');
        this.attrProductKey = this.getAtt('ProductKey');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.nodeType = props.nodeType;
        this.productName = props.productName;
        this.aliyunCommodityCode = props.aliyunCommodityCode;
        this.authType = props.authType;
        this.categoryKey = props.categoryKey;
        this.dataFormat = props.dataFormat;
        this.description = props.description;
        this.id2 = props.id2;
        this.iotInstanceId = props.iotInstanceId;
        this.joinPermissionId = props.joinPermissionId;
        this.netType = props.netType;
        this.protocolType = props.protocolType;
        this.publishAuto = props.publishAuto;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            nodeType: this.nodeType,
            productName: this.productName,
            aliyunCommodityCode: this.aliyunCommodityCode,
            authType: this.authType,
            categoryKey: this.categoryKey,
            dataFormat: this.dataFormat,
            description: this.description,
            id2: this.id2,
            iotInstanceId: this.iotInstanceId,
            joinPermissionId: this.joinPermissionId,
            netType: this.netType,
            protocolType: this.protocolType,
            publishAuto: this.publishAuto,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosProductPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProduct = RosProduct;
/**
 * The resource type name for this resource class.
 */
RosProduct.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Product";
/**
 * Determine whether the given properties match those of a `RosProductTopicProps`
 *
 * @param properties - the TypeScript properties of a `RosProductTopicProps`
 *
 * @returns the result of the validation.
 */
function RosProductTopicPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.desc && (Array.isArray(properties.desc) || (typeof properties.desc) === 'string')) {
        errors.collect(ros.propertyValidator('desc', ros.validateLength)({
            data: properties.desc.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('desc', ros.validateString)(properties.desc));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('topicShortName', ros.requiredValidator)(properties.topicShortName));
    errors.collect(ros.propertyValidator('topicShortName', ros.validateString)(properties.topicShortName));
    errors.collect(ros.propertyValidator('operation', ros.requiredValidator)(properties.operation));
    if (properties.operation && (typeof properties.operation) !== 'object') {
        errors.collect(ros.propertyValidator('operation', ros.validateAllowedValues)({
            data: properties.operation,
            allowedValues: ["ALL", "PUB", "SUB"],
        }));
    }
    errors.collect(ros.propertyValidator('operation', ros.validateString)(properties.operation));
    errors.collect(ros.propertyValidator('productKey', ros.requiredValidator)(properties.productKey));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    return errors.wrap('supplied properties not correct for "RosProductTopicProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::ProductTopic` resource
 *
 * @param properties - the TypeScript properties of a `RosProductTopicProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::ProductTopic` resource.
 */
// @ts-ignore TS6133
function rosProductTopicPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProductTopicPropsValidator(properties).assertSuccess();
    }
    return {
        Operation: ros.stringToRosTemplate(properties.operation),
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        TopicShortName: ros.stringToRosTemplate(properties.topicShortName),
        Desc: ros.stringToRosTemplate(properties.desc),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::ProductTopic`
 */
class RosProductTopic extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::ProductTopic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProductTopic.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrTopicId = this.getAtt('TopicId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.operation = props.operation;
        this.productKey = props.productKey;
        this.topicShortName = props.topicShortName;
        this.desc = props.desc;
        this.iotInstanceId = props.iotInstanceId;
    }
    get rosProperties() {
        return {
            operation: this.operation,
            productKey: this.productKey,
            topicShortName: this.topicShortName,
            desc: this.desc,
            iotInstanceId: this.iotInstanceId,
        };
    }
    renderProperties(props) {
        return rosProductTopicPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProductTopic = RosProductTopic;
/**
 * The resource type name for this resource class.
 */
RosProductTopic.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::ProductTopic";
/**
 * Determine whether the given properties match those of a `RosRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the result of the validation.
 */
function RosRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('topicType', ros.validateNumber)(properties.topicType));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.ruleAction && (Array.isArray(properties.ruleAction) || (typeof properties.ruleAction) === 'string')) {
        errors.collect(ros.propertyValidator('ruleAction', ros.validateLength)({
            data: properties.ruleAction.length,
            min: 1,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('ruleAction', ros.listValidator(RosRule_RuleActionPropertyValidator))(properties.ruleAction));
    errors.collect(ros.propertyValidator('shortTopic', ros.validateString)(properties.shortTopic));
    errors.collect(ros.propertyValidator('select', ros.validateString)(properties.select));
    errors.collect(ros.propertyValidator('startRule', ros.validateBoolean)(properties.startRule));
    if (properties.dataType && (typeof properties.dataType) !== 'object') {
        errors.collect(ros.propertyValidator('dataType', ros.validateAllowedValues)({
            data: properties.dataType,
            allowedValues: ["BINARY", "JSON"],
        }));
    }
    errors.collect(ros.propertyValidator('dataType', ros.validateString)(properties.dataType));
    errors.collect(ros.propertyValidator('ruleDesc', ros.validateString)(properties.ruleDesc));
    errors.collect(ros.propertyValidator('where', ros.validateString)(properties.where));
    errors.collect(ros.propertyValidator('productKey', ros.validateString)(properties.productKey));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "RosRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule` resource
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule` resource.
 */
// @ts-ignore TS6133
function rosRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRulePropsValidator(properties).assertSuccess();
    }
    return {
        Name: ros.stringToRosTemplate(properties.name),
        DataType: ros.stringToRosTemplate(properties.dataType),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
        ProductKey: ros.stringToRosTemplate(properties.productKey),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        RuleAction: ros.listMapper(rosRuleRuleActionPropertyToRosTemplate)(properties.ruleAction),
        RuleDesc: ros.stringToRosTemplate(properties.ruleDesc),
        Select: ros.stringToRosTemplate(properties.select),
        ShortTopic: ros.stringToRosTemplate(properties.shortTopic),
        StartRule: ros.booleanToRosTemplate(properties.startRule),
        TopicType: ros.numberToRosTemplate(properties.topicType),
        Where: ros.stringToRosTemplate(properties.where),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::Rule`
 */
class RosRule extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrActionId = this.getAtt('ActionId');
        this.attrRuleId = this.getAtt('RuleId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.name = props.name;
        this.dataType = props.dataType;
        this.iotInstanceId = props.iotInstanceId;
        this.productKey = props.productKey;
        this.resourceGroupId = props.resourceGroupId;
        this.ruleAction = props.ruleAction;
        this.ruleDesc = props.ruleDesc;
        this.select = props.select;
        this.shortTopic = props.shortTopic;
        this.startRule = props.startRule;
        this.topicType = props.topicType;
        this.where = props.where;
    }
    get rosProperties() {
        return {
            name: this.name,
            dataType: this.dataType,
            iotInstanceId: this.iotInstanceId,
            productKey: this.productKey,
            resourceGroupId: this.resourceGroupId,
            ruleAction: this.ruleAction,
            ruleDesc: this.ruleDesc,
            select: this.select,
            shortTopic: this.shortTopic,
            startRule: this.startRule,
            topicType: this.topicType,
            where: this.where,
        };
    }
    renderProperties(props) {
        return rosRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRule = RosRule;
/**
 * The resource type name for this resource class.
 */
RosRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::Rule";
/**
 * Determine whether the given properties match those of a `RuleActionProperty`
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the result of the validation.
 */
function RosRule_RuleActionPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.errorActionFlag && (typeof properties.errorActionFlag) !== 'object') {
        errors.collect(ros.propertyValidator('errorActionFlag', ros.validateAllowedValues)({
            data: properties.errorActionFlag,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('errorActionFlag', ros.validateString)(properties.errorActionFlag));
    errors.collect(ros.propertyValidator('type', ros.requiredValidator)(properties.type));
    if (properties.type && (typeof properties.type) !== 'object') {
        errors.collect(ros.propertyValidator('type', ros.validateAllowedValues)({
            data: properties.type,
            allowedValues: ["AMQP", "DATAHUB", "FC", "MNS", "ONS", "OTS", "REPUBLISH"],
        }));
    }
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('configuration', ros.requiredValidator)(properties.configuration));
    errors.collect(ros.propertyValidator('configuration', ros.validateString)(properties.configuration));
    return errors.wrap('supplied properties not correct for "RuleActionProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule.RuleAction` resource
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::Rule.RuleAction` resource.
 */
// @ts-ignore TS6133
function rosRuleRuleActionPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosRule_RuleActionPropertyValidator(properties).assertSuccess();
    return {
        ErrorActionFlag: ros.stringToRosTemplate(properties.errorActionFlag),
        Type: ros.stringToRosTemplate(properties.type),
        Configuration: ros.stringToRosTemplate(properties.configuration),
    };
}
/**
 * Determine whether the given properties match those of a `RosRuleActionProps`
 *
 * @param properties - the TypeScript properties of a `RosRuleActionProps`
 *
 * @returns the result of the validation.
 */
function RosRuleActionPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('errorActionFlag', ros.validateBoolean)(properties.errorActionFlag));
    errors.collect(ros.propertyValidator('type', ros.requiredValidator)(properties.type));
    if (properties.type && (typeof properties.type) !== 'object') {
        errors.collect(ros.propertyValidator('type', ros.validateAllowedValues)({
            data: properties.type,
            allowedValues: ["AMQP", "DATAHUB", "FC", "MNS", "ONS", "OTS", "REPUBLISH"],
        }));
    }
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('configuration', ros.requiredValidator)(properties.configuration));
    errors.collect(ros.propertyValidator('configuration', ros.validateString)(properties.configuration));
    errors.collect(ros.propertyValidator('iotInstanceId', ros.validateString)(properties.iotInstanceId));
    errors.collect(ros.propertyValidator('ruleId', ros.requiredValidator)(properties.ruleId));
    errors.collect(ros.propertyValidator('ruleId', ros.validateNumber)(properties.ruleId));
    return errors.wrap('supplied properties not correct for "RosRuleActionProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::IOT::RuleAction` resource
 *
 * @param properties - the TypeScript properties of a `RosRuleActionProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::IOT::RuleAction` resource.
 */
// @ts-ignore TS6133
function rosRuleActionPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRuleActionPropsValidator(properties).assertSuccess();
    }
    return {
        Configuration: ros.stringToRosTemplate(properties.configuration),
        RuleId: ros.numberToRosTemplate(properties.ruleId),
        Type: ros.stringToRosTemplate(properties.type),
        ErrorActionFlag: ros.booleanToRosTemplate(properties.errorActionFlag),
        IotInstanceId: ros.stringToRosTemplate(properties.iotInstanceId),
    };
}
/**
 * A ROS template type:  `ALIYUN::IOT::RuleAction`
 */
class RosRuleAction extends ros.RosResource {
    /**
     * Create a new `ALIYUN::IOT::RuleAction`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRuleAction.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrActionId = this.getAtt('ActionId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.configuration = props.configuration;
        this.ruleId = props.ruleId;
        this.type = props.type;
        this.errorActionFlag = props.errorActionFlag;
        this.iotInstanceId = props.iotInstanceId;
    }
    get rosProperties() {
        return {
            configuration: this.configuration,
            ruleId: this.ruleId,
            type: this.type,
            errorActionFlag: this.errorActionFlag,
            iotInstanceId: this.iotInstanceId,
        };
    }
    renderProperties(props) {
        return rosRuleActionPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRuleAction = RosRuleAction;
/**
 * The resource type name for this resource class.
 */
RosRuleAction.ROS_RESOURCE_TYPE_NAME = "ALIYUN::IOT::RuleAction";
//# sourceMappingURL=data:application/json;base64,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