"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcConnector = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
class VpcConnector extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcConnectorName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcConnector);
            }
            throw error;
        }
        const securityGroups = props.securityGroups?.length ?
            props.securityGroups
            : [new ec2.SecurityGroup(this, 'SecurityGroup', { vpc: props.vpc })];
        const resource = new aws_apprunner_1.CfnVpcConnector(this, 'Resource', {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnetIds,
            securityGroups: cdk.Lazy.list({ produce: () => this.connections.securityGroups.map(sg => sg.securityGroupId) }),
            vpcConnectorName: this.physicalName,
        });
        this.vpcConnectorArn = resource.attrVpcConnectorArn;
        this.vpcConnectorRevision = resource.attrVpcConnectorRevision;
        this.vpcConnectorName = resource.ref;
        this.connections = new aws_ec2_1.Connections({ securityGroups });
    }
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcConnectorAttributes);
            }
            throw error;
        }
        const vpcConnectorArn = attrs.vpcConnectorArn;
        const vpcConnectorName = attrs.vpcConnectorName;
        const vpcConnectorRevision = attrs.vpcConnectorRevision;
        const securityGroups = attrs.securityGroups;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcConnectorArn = vpcConnectorArn;
                this.vpcConnectorName = vpcConnectorName;
                this.vpcConnectorRevision = vpcConnectorRevision;
                this.connections = new aws_ec2_1.Connections({ securityGroups });
            }
        }
        return new Import(scope, id);
    }
}
exports.VpcConnector = VpcConnector;
_a = JSII_RTTI_SYMBOL_1;
VpcConnector[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcConnector", version: "2.34.2-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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