from dissect.util.ts import from_unix

from dissect.target.helpers.regutil import VirtualKey, VirtualValue
from dissect.target.plugins.os.windows.generic import GenericPlugin
from dissect.target.plugins.os.windows.registry import VirtualHive
from dissect.target.target import Target


def test_windows_generic_install_date(target_win_users: Target, hive_hklm: VirtualHive):
    currentversion_key_name = "Software\\Microsoft\\Windows NT\\CurrentVersion"
    currentversion_key = VirtualKey(hive_hklm, currentversion_key_name)
    currentversion_key.add_value("InstallDate", VirtualValue(hive_hklm, "InstallDate", 0))
    hive_hklm.map_key(currentversion_key_name, currentversion_key)
    target_win_users.add_plugin(GenericPlugin)

    assert target_win_users.install_date == from_unix(0)


def test_windows_generic_sid(target_win: Target, hive_hklm: VirtualHive):
    value_machine = b"\x00\x00\x00\x00H\x01\x00\x00\x03\x00\x01\x00H\x01\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00`\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00`\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x14\x80(\x01\x00\x008\x01\x00\x00\x14\x00\x00\x00D\x00\x00\x00\x02\x000\x00\x02\x00\x00\x00\x02\xc0\x14\x00z\x04\x05\x01\x01\x01\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x02\xc0\x14\x00\xff\x07\x0f\x00\x01\x01\x00\x00\x00\x00\x00\x05\x07\x00\x00\x00\x02\x00\xe4\x00\x08\x00\x00\x00\x00\x00\x14\x00\x85\x03\x02\x00\x01\x01\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x18\x00\x85\x03\x02\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00!\x02\x00\x00\x00\x00\x18\x00\xdf\x07\x0f\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00 \x02\x00\x00\x00\x00\x18\x00\x85\x03\x02\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00#\x02\x00\x00\x00\x00\x18\x00\xd5\x03\x02\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00$\x02\x00\x00\x00\x008\x00\x85\x03\x02\x00\x01\n\x00\x00\x00\x00\x00\x0f\x03\x00\x00\x00\x00\x04\x00\x00\xde\xa2(g!>\xd2\xaf\x19\xad]y\xb0\xc1\x07)'V\xfc \xd8\xadf\xf6\x10\xf2h\xfa\xdf*\xf8\x0f\x01\x00\x18\x00P\x00\x00\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00#\x02\x00\x00\x01\x00\x18\x00P\x00\x00\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00#\x02\x00\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00 \x02\x00\x00\x01\x02\x00\x00\x00\x00\x00\x05 \x00\x00\x00 \x02\x00\x00\x01\x04\x00\x00\x00\x00\x00\x05\x15\x00\x00\x00\xc3,HH\xddV\r\xd1\xab\xbe\x8a\xe0"  # noqa: E501

    value_domain = (
        b"\x01\x05\x00\x00\x00\x00\x00\x05\x15\x00\x00\x00\xc8\x13\x95z\x9c\xf0\xcd\x83I\xd9\x9e\xb9E\x06\x00\x00"
    )
    machine_sid_key_name = "SAM\\SAM\\Domains\\Account"
    domain_sid_key_name = "SECURITY\\Policy\\PolMachineAccountS"

    machine_sid_key = VirtualKey(hive_hklm, machine_sid_key_name)
    domain_sid_key = VirtualKey(hive_hklm, domain_sid_key_name)

    machine_sid_key.add_value("V", VirtualValue(hive_hklm, "V", value_machine))
    domain_sid_key.add_value("(Default)", VirtualValue(hive_hklm, "(Default)", value_domain))

    hive_hklm.map_key(machine_sid_key_name, machine_sid_key)
    hive_hklm.map_key(domain_sid_key_name, domain_sid_key)
    target_win.add_plugin(GenericPlugin)

    records = list(target_win.sid())

    assert len(records) == 2

    assert records[0].sid == "S-1-5-21-1212689603-3507312349-3767189163"
    assert records[0].sidtype == "Machine"

    assert records[1].sid == "S-1-5-21-2056590280-2211311772-3114195273-1605"
    assert records[1].sidtype == "Domain"
