/// Files: net/x25/af_x25.c net/x25/x25_subr.c
/// Fix: 7781607938c8371d4c2b243527430241c62e39c2
/// Fixes: 4becb7ee5b3d2829ed7b9261a245a77d5b7de902
/// Version: 1.0.7

virtual detect

@disconnect@
identifier x25, x25_list_lock;
@@

x25_disconnect(...)
{
	...
*	read_lock_bh(&x25_list_lock);
*	x25_neigh_put(x25->neighbour);
*	x25->neighbour = NULL;
*	read_unlock_bh(&x25_list_lock);
	...
}

@err depends on disconnect@
identifier x25_list, s, nb;
iterator name sk_for_each;
position p;
@@

x25_kill_by_neigh(struct x25_neigh *nb)
{
	...
	sk_for_each(s, &x25_list)
		if (x25_sk(s)->neighbour == nb)
*			x25_disconnect@p(s, ENETUNREACH, 0, 0);
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-1516')
