/// Files: kernel/cgroup/cgroup-v1.c kernel/cgroup/cgroup.c kernel/cgroup.c
/// Fix: 24f6008564183aa120d07c03d9289519c2fe02af
/// Fixes: 81a6a5cdd2c5cd70874b88afe524ab09e9e869af
/// Version: 1.0.7

virtual detect

@err_cgroup_release_agent_write@
identifier of;
expression root, ns;
symbol init_user_ns;
position p;
@@

cgroup_release_agent_write(...)
{
	... when != if ((ns->user_ns != &init_user_ns) || !capable(CAP_SYS_ADMIN)) return ...;
	    when != if ((ns->user_ns != &init_user_ns) || !file_ns_capable(of->file, &init_user_ns, CAP_SYS_ADMIN)) return ...;
*	\(strcpy@p\|strlcpy@p\|strncpy@p\)(root->release_agent_path, ...)
	...
}

@err_mount exists@
identifier out, opts;
expression root, ns;
symbol init_user_ns;
position p;
@@

\(cgroup_mount\|cgroup_remount\)(...)
{
	... when != if (opts.release_agent && ((ns->user_ns != &init_user_ns) || !capable(CAP_SYS_ADMIN))) { ... goto out; }
(
*	\(strcpy@p\|strlcpy@p\|strncpy@p\)(root->release_agent_path, opts.release_agent, ...)
|
*	init_cgroup_root@p(root, &opts)
)
	...
}

@err_cgroup1_parse_param exists@
expression ctx, fc;
identifier param;
symbol init_user_ns;
position p;
@@

cgroup1_parse_param(...)
{
	... when != if ((fc->user_ns != &init_user_ns) || !capable(CAP_SYS_ADMIN)) return ...;
*	ctx->release_agent =@p param->string;
	...
}

@script:python depends on detect@
p << err_cgroup_release_agent_write.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-0492')

@script:python depends on detect@
p << err_mount.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-0492')

@script:python depends on detect@
p << err_cgroup1_parse_param.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2022-0492')
