/// Files: security/selinux/hooks.c security/smack/smack_lsm.c
/// Fix: a3727a8bac0a9e77c70820655fd8715523ba3db7
/// Fixes: eb1231f73c4d7dc26db55e08c070e6526eaf7ee5

virtual detect

@err_selinux_ptrace_traceme@
identifier parent;
symbol selinux_state, current;
position p;
@@

selinux_ptrace_traceme(struct task_struct *parent)
{
	return avc_has_perm(&selinux_state,
*			    task_sid_subj@p(parent),
			    task_sid_obj(current),
			    ...);
}

@err_selinux_msg_queue_msgrcv@
identifier target, sid;
position p;
@@

selinux_msg_queue_msgrcv(..., struct task_struct *target, ...)
{
	...
*	u32 sid = task_sid_subj@p(target);
	...
}

@err_smk_curacc_on_task@
identifier p, skp;
position p1;
@@

smk_curacc_on_task(struct task_struct *p, ...)
{
	...
*	struct smack_known *skp = smk_of_task_struct_subj@p1(p);
	...
}

@err_smack_getprocattr@
identifier p, skp;
position p1;
@@

smack_getprocattr(struct task_struct *p, ...)
{
	...
*	struct smack_known *skp = smk_of_task_struct_subj@p1(p);
	...
}

@script:python depends on detect@
p << err_selinux_ptrace_traceme.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43057')

@script:python depends on detect@
p << err_selinux_msg_queue_msgrcv.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43057')

@script:python depends on detect@
p << err_smk_curacc_on_task.p1;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43057')

@script:python depends on detect@
p << err_smack_getprocattr.p1;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-43057')
