/// Files: fs/btrfs/extent-tree.c
/// Fix: 19ea40dddf1833db868533958ca066f368862211
/// Detect-To: 67b7859e9bfa0dcee5a8256932e393e98739be1b

virtual detect

@lock_exists@
identifier buf;
@@

btrfs_init_new_buffer(...)
{
	...
*	\(btrfs_tree_lock\|__btrfs_tree_lock\)(buf, ...);
	... when any
	return buf;
}

@err depends on lock_exists@
identifier buf, out_free_buf;
position p;
@@

btrfs_alloc_tree_block(...)
{
	...
*	buf = btrfs_init_new_buffer(...);
	... when any
*	goto out_free_buf;
	...
out_free_buf:
	... when != btrfs_tree_unlock(buf);
*	free_extent_buffer@p(buf);
	...
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-4149')
