/// Files: fs/nfsd/vfs.c include/linux/nfs4.h
/// Fix: 22cf8419f1319ff87ec759d0ebdff4cbafaee832
/// Fixes: 47057abde515155a4fee53038e7772d6b387e0aa
/// Version: 1.1.0

virtual detect

@nfs_attr_umask@
@@

* #define FATTR4_WORD2_MODE_UMASK		(1UL << 17)

@err_nfsd_create_locked depends on nfs_attr_umask@
identifier dirp, iap;
position p;
@@

nfsd_create_locked(...)
{
	... when != if (!IS_POSIXACL(dirp)) iap->ia_mode &= ~current_umask();
*	\(vfs_create@p\|vfs_mkdir@p\|vfs_mknod@p\)(dirp, ..., iap->ia_mode, ...)
	...
}

@err_do_nfsd_create depends on nfs_attr_umask@
identifier dirp, iap;
position p;
@@

do_nfsd_create(...)
{
	... when != if (!IS_POSIXACL(dirp)) iap->ia_mode &= ~current_umask();
*	vfs_create@p(dirp, ..., iap->ia_mode, ...)
	...
}

@script:python depends on detect@
p << err_nfsd_create_locked.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-24394')

@script:python depends on detect@
p << err_do_nfsd_create.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-24394')
