/// Files: crypto/af_alg.c net/socket.c
/// Fix: 9060cb719e61b685ec0102574e10337fa5f445ea
/// Fixes: 6d8c50dcb029872b298eea68cc6209c866fd3e14

virtual detect

@sockfs_setattr@
identifier sock, iattr;
@@

sockfs_setattr(...)
{
	...
	if (sock->sk)
		sock->sk->sk_uid = iattr->ia_uid;
	else
		err = -ENOENT;
	...
}

@err depends on sockfs_setattr@
identifier sock;
position p;
@@

af_alg_release(struct socket *sock)
{
*	if (sock->sk)
*		sock_put@p(sock->sk);
	return 0;
}

@script:python depends on detect@
p << err.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2019-8912')
