/// Files: drivers/char/random.c
/// Fix: 43838a23a05fbd13e47d750d3dfd77001536dd33
/// Fixes: e192be9d9a30555aae2ca1dc3aad37cba484cd4a
/// Version: 1.0.7

virtual detect

@err_crng_ready exists@
symbol crng_init;
position p;
@@

* #define crng_ready() (likely(crng_init >@p 0))

@err_crng_fast_load depends on err_crng_ready exists@
identifier flags;
symbol primary_crng;
position p;
@@

crng_fast_load(...)
{
	...
	spin_trylock_irqsave(&primary_crng.lock, flags)
	...
*	if (crng_ready@p()) {
		...
		spin_unlock_irqrestore(&primary_crng.lock, flags);
		...
	}
	...
}

@err_extract_crng depends on err_crng_ready exists@
identifier jiffies, crng;
symbol crng_init;
position p;
@@

\(_extract_crng\|extract_crng\)(...)
{
	...
*	if (crng_init >@p 1 &&
 	    time_after(jiffies, crng->init_time + CRNG_RESEED_INTERVAL))
 		crng_reseed(crng, ...);
	...
}

@err_add_interrupt_randomness depends on err_crng_ready exists@
position p;
@@

add_interrupt_randomness(...)
{
	...
*	if (!crng_ready@p()) {
		...
	}
	...
}

@err_add_hwgenerator_randomness depends on err_crng_ready exists@
position p;
@@

add_hwgenerator_randomness(...)
{
	...
*	if (!crng_ready@p()) {
		...
 		crng_fast_load(...);
		...
 	}
	...
}

@script:python depends on detect@
p << err_crng_ready.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-1108')

@script:python depends on detect@
p << err_crng_fast_load.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-1108')

@script:python depends on detect@
p << err_extract_crng.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-1108')

@script:python depends on detect@
p << err_add_interrupt_randomness.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-1108')

@script:python depends on detect@
p << err_add_hwgenerator_randomness.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2018-1108')
