# coding: utf-8

"""
    SatNOGS Network

    SatNOGS Network is a web application, implementing a global scheduling and monitoring network for ground station operations.  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from satnogsnetworkapiclient.api_client import ApiClient
from satnogsnetworkapiclient.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_observation(self, **kwargs):  # noqa: E501
        """create_observation  # noqa: E501

        Creates observations from a list of observation data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_observation(async_req=True)
        >>> result = thread.get()

        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.create_observation_with_http_info(**kwargs)  # noqa: E501

    def create_observation_with_http_info(self, **kwargs):  # noqa: E501
        """create_observation  # noqa: E501

        Creates observations from a list of observation data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_observation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_observation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/observations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_jobs(self, **kwargs):  # noqa: E501
        """list_jobs  # noqa: E501

        SatNOGS Network Job API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_jobs(async_req=True)
        >>> result = thread.get()

        :param id: id
        :type id: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[object]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_jobs_with_http_info(**kwargs)  # noqa: E501

    def list_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_jobs  # noqa: E501

        SatNOGS Network Job API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param id: id
        :type id: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[object], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "list[object]",
        }

        return self.api_client.call_api(
            '/api/jobs/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_observations(self, **kwargs):  # noqa: E501
        """list_observations  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_observations(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param id: id
        :type id: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InlineResponse200
        """
        kwargs['_return_http_data_only'] = True
        return self.list_observations_with_http_info(**kwargs)  # noqa: E501

    def list_observations_with_http_info(self, **kwargs):  # noqa: E501
        """list_observations  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_observations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param id: id
        :type id: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page',
            'id',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_observations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "InlineResponse200",
        }

        return self.api_client.call_api(
            '/api/observations/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_stations(self, **kwargs):  # noqa: E501
        """list_stations  # noqa: E501

        SatNOGS Network Station API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stations(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param id: id
        :type id: str
        :param name: name
        :type name: str
        :param status: status
        :type status: str
        :param client_version: client_version
        :type client_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InlineResponse2001
        """
        kwargs['_return_http_data_only'] = True
        return self.list_stations_with_http_info(**kwargs)  # noqa: E501

    def list_stations_with_http_info(self, **kwargs):  # noqa: E501
        """list_stations  # noqa: E501

        SatNOGS Network Station API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_stations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param id: id
        :type id: str
        :param name: name
        :type name: str
        :param status: status
        :type status: str
        :param client_version: client_version
        :type client_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InlineResponse2001, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page',
            'id',
            'name',
            'status',
            'client_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_stations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'client_version' in local_var_params and local_var_params['client_version'] is not None:  # noqa: E501
            query_params.append(('client_version', local_var_params['client_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "InlineResponse2001",
        }

        return self.api_client.call_api(
            '/api/stations/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_transmitters(self, **kwargs):  # noqa: E501
        """list_transmitters  # noqa: E501

        SatNOGS Network Transmitter API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transmitters(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param uuid: uuid
        :type uuid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InlineResponse2002
        """
        kwargs['_return_http_data_only'] = True
        return self.list_transmitters_with_http_info(**kwargs)  # noqa: E501

    def list_transmitters_with_http_info(self, **kwargs):  # noqa: E501
        """list_transmitters  # noqa: E501

        SatNOGS Network Transmitter API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transmitters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: A page number within the paginated result set.
        :type page: int
        :param uuid: uuid
        :type uuid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InlineResponse2002, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page',
            'uuid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transmitters" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'uuid' in local_var_params and local_var_params['uuid'] is not None:  # noqa: E501
            query_params.append(('uuid', local_var_params['uuid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "InlineResponse2002",
        }

        return self.api_client.call_api(
            '/api/transmitters/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def partial_update_observation(self, id, **kwargs):  # noqa: E501
        """partial_update_observation  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partial_update_observation(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_observation_with_http_info(id, **kwargs)  # noqa: E501

    def partial_update_observation_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_observation  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partial_update_observation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'id2',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_observation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `partial_update_observation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'id2' in local_var_params and local_var_params['id2'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id2']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/observations/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def retrieve_job(self, id, **kwargs):  # noqa: E501
        """retrieve_job  # noqa: E501

        SatNOGS Network Job API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_job(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_job_with_http_info(id, **kwargs)  # noqa: E501

    def retrieve_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_job  # noqa: E501

        SatNOGS Network Job API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'id2',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `retrieve_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'id2' in local_var_params and local_var_params['id2'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id2']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/jobs/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def retrieve_observation(self, id, **kwargs):  # noqa: E501
        """retrieve_observation  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_observation(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_observation_with_http_info(id, **kwargs)  # noqa: E501

    def retrieve_observation_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_observation  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_observation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'id2',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_observation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `retrieve_observation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'id2' in local_var_params and local_var_params['id2'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id2']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/observations/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def retrieve_station(self, id, **kwargs):  # noqa: E501
        """retrieve_station  # noqa: E501

        SatNOGS Network Station API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_station(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this station. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param name: name
        :type name: str
        :param status: status
        :type status: str
        :param client_version: client_version
        :type client_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_station_with_http_info(id, **kwargs)  # noqa: E501

    def retrieve_station_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_station  # noqa: E501

        SatNOGS Network Station API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_station_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this station. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param name: name
        :type name: str
        :param status: status
        :type status: str
        :param client_version: client_version
        :type client_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'id2',
            'name',
            'status',
            'client_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_station" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `retrieve_station`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'id2' in local_var_params and local_var_params['id2'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id2']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'client_version' in local_var_params and local_var_params['client_version'] is not None:  # noqa: E501
            query_params.append(('client_version', local_var_params['client_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/stations/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def retrieve_transmitter(self, transmitter_uuid, **kwargs):  # noqa: E501
        """retrieve_transmitter  # noqa: E501

        SatNOGS Network Transmitter API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_transmitter(transmitter_uuid, async_req=True)
        >>> result = thread.get()

        :param transmitter_uuid: (required)
        :type transmitter_uuid: str
        :param uuid: uuid
        :type uuid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.retrieve_transmitter_with_http_info(transmitter_uuid, **kwargs)  # noqa: E501

    def retrieve_transmitter_with_http_info(self, transmitter_uuid, **kwargs):  # noqa: E501
        """retrieve_transmitter  # noqa: E501

        SatNOGS Network Transmitter API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_transmitter_with_http_info(transmitter_uuid, async_req=True)
        >>> result = thread.get()

        :param transmitter_uuid: (required)
        :type transmitter_uuid: str
        :param uuid: uuid
        :type uuid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'transmitter_uuid',
            'uuid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_transmitter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transmitter_uuid' is set
        if self.api_client.client_side_validation and ('transmitter_uuid' not in local_var_params or  # noqa: E501
                                                        local_var_params['transmitter_uuid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transmitter_uuid` when calling `retrieve_transmitter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transmitter_uuid' in local_var_params:
            path_params['transmitter_uuid'] = local_var_params['transmitter_uuid']  # noqa: E501

        query_params = []
        if 'uuid' in local_var_params and local_var_params['uuid'] is not None:  # noqa: E501
            query_params.append(('uuid', local_var_params['uuid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/transmitters/{transmitter_uuid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_observation(self, id, **kwargs):  # noqa: E501
        """update_observation  # noqa: E501

        Updates observation with audio, waterfall or demoded data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_observation(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.update_observation_with_http_info(id, **kwargs)  # noqa: E501

    def update_observation_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_observation  # noqa: E501

        Updates observation with audio, waterfall or demoded data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_observation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer value identifying this observation. (required)
        :type id: str
        :param id2: id
        :type id2: str
        :param status: status
        :type status: str
        :param ground_station: ground_station
        :type ground_station: str
        :param start: start
        :type start: str
        :param end: end
        :type end: str
        :param satellite__norad_cat_id: satellite__norad_cat_id
        :type satellite__norad_cat_id: str
        :param transmitter_uuid: transmitter_uuid
        :type transmitter_uuid: str
        :param transmitter_mode: transmitter_mode
        :type transmitter_mode: str
        :param transmitter_type: transmitter_type
        :type transmitter_type: str
        :param waterfall_status: waterfall_status
        :type waterfall_status: str
        :param vetted_status: Vetted status (deprecated: please use Status)
        :type vetted_status: str
        :param vetted_user: Vetted user (deprecated: will be removed in next version)
        :type vetted_user: str
        :param unknown_base_type:
        :type unknown_base_type: UNKNOWN_BASE_TYPE
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'id2',
            'status',
            'ground_station',
            'start',
            'end',
            'satellite__norad_cat_id',
            'transmitter_uuid',
            'transmitter_mode',
            'transmitter_type',
            'waterfall_status',
            'vetted_status',
            'vetted_user',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_observation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_observation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'id2' in local_var_params and local_var_params['id2'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id2']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'ground_station' in local_var_params and local_var_params['ground_station'] is not None:  # noqa: E501
            query_params.append(('ground_station', local_var_params['ground_station']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'end' in local_var_params and local_var_params['end'] is not None:  # noqa: E501
            query_params.append(('end', local_var_params['end']))  # noqa: E501
        if 'satellite__norad_cat_id' in local_var_params and local_var_params['satellite__norad_cat_id'] is not None:  # noqa: E501
            query_params.append(('satellite__norad_cat_id', local_var_params['satellite__norad_cat_id']))  # noqa: E501
        if 'transmitter_uuid' in local_var_params and local_var_params['transmitter_uuid'] is not None:  # noqa: E501
            query_params.append(('transmitter_uuid', local_var_params['transmitter_uuid']))  # noqa: E501
        if 'transmitter_mode' in local_var_params and local_var_params['transmitter_mode'] is not None:  # noqa: E501
            query_params.append(('transmitter_mode', local_var_params['transmitter_mode']))  # noqa: E501
        if 'transmitter_type' in local_var_params and local_var_params['transmitter_type'] is not None:  # noqa: E501
            query_params.append(('transmitter_type', local_var_params['transmitter_type']))  # noqa: E501
        if 'waterfall_status' in local_var_params and local_var_params['waterfall_status'] is not None:  # noqa: E501
            query_params.append(('waterfall_status', local_var_params['waterfall_status']))  # noqa: E501
        if 'vetted_status' in local_var_params and local_var_params['vetted_status'] is not None:  # noqa: E501
            query_params.append(('vetted_status', local_var_params['vetted_status']))  # noqa: E501
        if 'vetted_user' in local_var_params and local_var_params['vetted_user'] is not None:  # noqa: E501
            query_params.append(('vetted_user', local_var_params['vetted_user']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501
        
        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/api/observations/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
