from setuptools import setup, find_packages

setup(
    name='wave_length',  # 包名
    version='1.3',  # 版本
    description="使用步长为0.1 nm 的标准CIE色度匹配图进行光谱波长计算",  # 包简介
    long_description=open('README.md', encoding='utf8').read(),  # 读取文件中介绍包的详细内容
    include_package_data=True,  # 是否允许上传资源文件
    author='LiuBing',  # 作者
    author_email='2577082896@qq.com',  # 作者邮件
    maintainer='LiuBing',  # 维护者
    maintainer_email='2577082896@qq.com',  # 维护者邮件
    license='MIT License',  # 协议
    url='https://github.com/royallucky/',  # github或者自己的网站地址
    packages=find_packages(),  # 包的目录
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',  # 设置编写时的python版本
    ],
    python_requires='>=3.6',  # 设置python版本要求
    install_requires=['numpy', 'pandas', 'matplotlib'],  # 安装所需要的库
    entry_points={
        'console_scripts': [
            ''],
    },  # 设置命令行工具(可不使用就可以注释掉)

)