"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSlo = exports.ThresholdTimeframe = exports.CfnSloPropsType = exports.toJson_Threshold = exports.toJson_Query = exports.toJson_Creator = exports.toJson_CfnSloProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSloProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSloProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Creator': toJson_Creator(obj.creator),
        'Description': obj.description,
        'Groups': obj.groups?.map(y => y),
        'MonitorIds': obj.monitorIds?.map(y => y),
        'Name': obj.name,
        'Query': toJson_Query(obj.query),
        'Tags': obj.tags?.map(y => y),
        'Thresholds': obj.thresholds?.map(y => toJson_Threshold(y)),
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSloProps = toJson_CfnSloProps;
/**
 * Converts an object of type 'Creator' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Creator(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Handle': obj.handle,
        'Email': obj.email,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Creator = toJson_Creator;
/**
 * Converts an object of type 'Query' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Query(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Numerator': obj.numerator,
        'Denominator': obj.denominator,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Query = toJson_Query;
/**
 * Converts an object of type 'Threshold' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Threshold(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Target': obj.target,
        'TargetDisplay': obj.targetDisplay,
        'Timeframe': obj.timeframe,
        'Warning': obj.warning,
        'WarningDisplay': obj.warningDisplay,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Threshold = toJson_Threshold;
/* eslint-enable max-len, quote-props */
/**
 * The type of the slo
 *
 * @schema CfnSloPropsType
 */
var CfnSloPropsType;
(function (CfnSloPropsType) {
    /** monitor */
    CfnSloPropsType["MONITOR"] = "monitor";
    /** metric */
    CfnSloPropsType["METRIC"] = "metric";
})(CfnSloPropsType = exports.CfnSloPropsType || (exports.CfnSloPropsType = {}));
/**
 * The SLO time window options. Allowed enum values: 7d,30d,90d
 *
 * @schema ThresholdTimeframe
 */
var ThresholdTimeframe;
(function (ThresholdTimeframe) {
    /** 7d */
    ThresholdTimeframe["VALUE_7D"] = "7d";
    /** 30d */
    ThresholdTimeframe["VALUE_30D"] = "30d";
    /** 90d */
    ThresholdTimeframe["VALUE_90D"] = "90d";
})(ThresholdTimeframe = exports.ThresholdTimeframe || (exports.ThresholdTimeframe = {}));
/**
 * A CloudFormation `Datadog::SLOs::SLO`
 *
 * @cloudformationResource Datadog::SLOs::SLO
 * @stability external
 * @link http://unknown-url
 */
class CfnSlo extends cdk.CfnResource {
    /**
     * Create a new `Datadog::SLOs::SLO`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSlo.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSloProps(props) });
        this.props = props;
        this.attrModified = cdk.Token.asString(this.getAtt('Modified'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrDeleted = cdk.Token.asString(this.getAtt('Deleted'));
        this.attrCreated = cdk.Token.asString(this.getAtt('Created'));
    }
}
exports.CfnSlo = CfnSlo;
_a = JSII_RTTI_SYMBOL_1;
CfnSlo[_a] = { fqn: "@cdk-cloudformation/datadog-slos-slo.CfnSlo", version: "1.0.1-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSlo.CFN_RESOURCE_TYPE_NAME = "Datadog::SLOs::SLO";
//# sourceMappingURL=data:application/json;base64,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