# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['httpie_credential_store']

package_data = \
{'': ['*']}

install_requires = \
['httpie>=3.1,<4.0', 'keyring>=23.5,<24.0']

entry_points = \
{'httpie.plugins.auth.v1': ['credential-store = '
                            'httpie_credential_store:CredentialStoreAuthPlugin',
                            'creds = httpie_credential_store:CredsAuthPlugin']}

setup_kwargs = {
    'name': 'httpie-credential-store',
    'version': '3.0.0',
    'description': 'HTTPie: one auth to rule them all!',
    'long_description': 'Credential store plugin for HTTPie\n==================================\n\nHTTPie Credential Store is an `HTTPie`_ authentication plugin that looks\nfor credentials using a given URL and attaches them to the ongoing HTTP\nrequest. That said, you don\'t need to memorize and/or look for\ntokens/username/passwords anymore. Simply add them to the credential\nstore and everything else will be done for you by this plugin. It goes\nwithout saying that this plugin supports various secured secret storages\nsuch as system keychains or password managers (see keychain providers).\n\nEager to get started? Just start with installing!\n\n.. code:: bash\n\n   $ python3 -m pip install httpie-credential-store\n\n\nUsage\n-----\n\n.. note:: Please, do not forget to activate the plugin by invoking\n          ``http`` with ``-A creds`` option.\n\nOnce installed, the plugin will look for credentials in the credential\nfile. The credential file is stored in HTTPie configuration directory.\nSo on Linux/macOS, it will look for ``~/.httpie/credentials.json``,\nwhile on Windows - for ``%APPDATA%\\httpie\\credentials.json``. The\ncredential file will not be created for you, you\'re fully responsible\nfor creating one.\n\nBy its nature, the credentials file is a JSON array of credential\nrecords. Each credential record consists of the following properties:\n\n* ``url`` (*required*) is a regular expression pattern that is used to\n  map credential record to the ongoing HTTP request. I.e. if the regular\n  expression matches URL of the ongoing HTTP request, credentials of\n  matched record must be attached.\n\n* ``auth`` (*required*) is an authentication provider to use for a given\n  record. The provider will be used to attach credentials to the ongoing\n  HTTP request if the record is matched.\n\n* ``id`` (*optional*) is unique identifier of the credential record that\n  can be used to solve ambiguousness between two or more matched\n  credential records. By using ``id`` one may achieve support of\n  multiple accounts for the same service.\n\nExample:\n\n.. code:: json\n\n   [\n     {\n       "url": "api.github.com",\n       "auth": {\n         "provider": "token",\n         "token": "your-github-oauth-token",\n         "scheme": "token"\n       }\n     },\n     {\n       "id": "bots",\n       "url": "api.github.com",\n       "auth": {\n         "provider": "token",\n         "token": "bots-github-oauth-token",\n         "scheme": "token"\n       }\n     }\n   ]\n\nThe example above assumes you store your secrets unencrypted in the\ncredential file. Despite enforcing you to set sole access permissions\nfor the credential file, it\'s not secured and, hence, not recommended.\nHTTPie Credential Store plugin can pull secrets and other sensitive\ninformation out from password managers or system keychains. For\ninstance, you can pull your token from the `password store`_ by using\nthe following credential record:\n\n.. code:: json\n\n   [\n     {\n       "url": "api.github.com",\n       "auth": {\n         "provider": "token",\n         "scheme": "token",\n         "token": {\n           "keychain": "password-store",\n           "name": "github.com/ikalnytskyi/token"\n         }\n       }\n     }\n   ]\n\nOnce the credential store is filled, you\'re ready to use the plugin at\nyour will. In order to activate the plugin, you must pass ``-A creds``\nor ``-A credential-store`` to ``http`` executable.\n\n.. code:: bash\n\n   $ http -A creds https://api.github.com\n\nOptionally, you can provide an ID of the credential record to use by\npassing ``-a`` argument.\n\n.. code:: bash\n\n   $ http -A creds -a bots https://api.github.com\n\n\nAuthentication providers\n------------------------\n\nHTTPie Credential Store comes with the following authentication\nproviders out of box.\n\n\n``basic``\n.........\n\nThe \'Basic\' HTTP authentication scheme as defined in :RFC:`7617`.\nTransmits credentials as username/password pairs, encoded using Base64.\n\n.. code:: json\n\n   {\n     "provider": "basic",\n     "username": "ikalnytskyi",\n     "password": "p@ss"\n   }\n\nwhere\n\n* ``username`` is a username to authenticate\n* ``password`` is a password of the authenticating user\n\n\n``digest``\n..........\n\nThe \'Digest\' HTTP authentication scheme as defined in :RFC:`2617`. It\napplies a hash function to the username and password before sending them\nover the network.\n\n.. code:: json\n\n   {\n     "provider": "digest",\n     "username": "ikalnytskyi",\n     "password": "p@ss"\n   }\n\nwhere\n\n* ``username`` is a username to authenticate\n* ``password`` is a password of the authenticating user\n\n\n``token``\n.........\n\nThe \'Token\' HTTP authentication scheme (also called \'Bearer\') transmits\ntoken in the ``Authorization`` HTTP header.\n\n.. code:: json\n\n   {\n     "provider": "token",\n     "token": "t0k3n",\n     "scheme": "JWT"\n   }\n\nwhere\n\n* ``token`` is a token of the authenticating user\n* ``scheme`` (optional, default: "Bearer") is an authenticating scheme\n\n\n``header``\n..........\n\nThe \'Header\' HTTP authentication is not exactly an authentication\nscheme. It\'s rather a way to pass any free-formed HTTP header with\nsecret or not.\n\n.. code:: json\n\n   {\n     "provider": "header",\n     "name": "X-Extra-Key",\n     "value": "k3y"\n   }\n\nwhere\n\n* ``name`` is an HTTP header name to use\n* ``value`` is an HTTP header value to pass\n\n\n``multiple``\n............\n\nThis is a fake authentication scheme even in terms of this plugin. It\ndoes no auth but chains and applies one or more providers\nsimultaneously. It\'s something you will (likely) never use.\n\n.. code:: json\n\n   {\n     "provider": "multiple",\n     "providers": [\n       {\n         "provider": "token",\n         "token": "t0k3n"\n       },\n       {\n         "provider": "header",\n         "name": "X-Extra-Key",\n         "value": "k3y"\n       }\n     ]\n   }\n\nwhere\n\n* ``providers`` is a list of auth providers to use simultaneously\n\n\nKeychain providers\n------------------\n\nThe plugin supports a bunch of keychains that can be used to pull\nsecrets from secured storage.\n\n\n``shell``\n.........\n\nShell provider is nothing more but a mere shell command to execute. The\ncommand must return a secret to the plugin via standard output stream.\nThis is a universal approach that can be used to glue together various\nunsupported password managers and/or keychains.\n\nExample:\n\n.. code:: json\n\n   {\n     "keychain": "shell",\n     "command": "cat ~/path/to/secret | tr -d \'\\n\'"\n   }\n\nwhere\n\n* ``command`` is a shell command to execute\n\n\n\n``system``\n..........\n\nSystem provider, as the name suggests, use your system keychain to pull\nsecrets from. It may be **KWallet**, **GNOME Keyring**, **macOS\nKeychain** or even **Windows Credential Locker**.\n\nExample:\n\n.. code:: json\n\n   {\n     "keychain": "system",\n     "service": "github",\n     "username": "ikalnytskyi"\n   }\n\nwhere\n\n* ``service`` is a service to pull data for\n* ``username`` is a username for that service to pull data for\n\n\n``password-store``\n..................\n\nPassword store provider is a bridge between this plugin and the\n`password store`_. It invokes ``pass`` on your system and pulls the\nsecret from the first line of the stored record (normally password).\n\nExample:\n\n.. code:: json\n\n   {\n     "keychain": "password-store",\n     "name": "github.com/ikalnytskyi"\n   }\n\nwhere\n\n* ``name`` is a pass name in terms of the password store\n\nFAQ\n---\n\n* **Q**: How to learn which credentials have been attached to the request?\n\n  **A**: Unfortunately, due to late credentials binding, it\'s impossible\n  to learn which credentials have been used by running ``http --debug``\n  command. Nevertheless, one can check amends made by auth providers by\n  inspect HTTP headers transmitted within the request by passing ``-v``\n  argument to HTTPie: ``http -v``.\n\n\n.. _HTTPie: https://httpie.org/\n.. _password store: https://www.passwordstore.org/\n',
    'author': 'Ihor Kalnytskyi',
    'author_email': 'ihor@kalnytskyi.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ikalnytskyi/httpie-credential-store',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
