# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_lo.ipynb.

# %% auto 0
__all__ = ['Lo', 'lo']

# %% ../nbs/10_lo.ipynb 3
from typing import Any, Union, Optional as O
from matplotlib import pyplot as plt, axes, figure


import numpy as np
from fastcore.all import store_attr

from .utils import history_warning
from .repr_str import lovely
from .repr_plt import PlotProxy
from .repr_rgb import RGBProxy
from .repr_chans import ChanProxy

# %% ../nbs/10_lo.ipynb 4
class Lo():
    """Lo and behold! What a lovely `numpy.ndarray`!"""
    def __init__(   self,
                    x: Union[np.ndarray, np.generic], # Your data
                    plain       =False, # Show as plain text - values only
                    verbose     =False, # Verbose - show values too
                    depth       =0,     # Expand up to `depth`
                    color :O[bool] =None): # Use ANSI colors
        self.x      =x
        self.plain  =plain
        self.verbose=verbose
        self.depth  =depth
        self.color  =color


        history_warning()

    def __repr__(self):
        return lovely(self.x, plain=self.plain, verbose=self.verbose,
                      depth=self.depth, color=self.color)

    @property
    def v(self):
        "Verbose"
        return Lo(self.x, verbose=True, color=self.color)

    @property
    def p(self):
        "Good old plain representation"
        return Lo(self.x, plain=True, color=self.color)

    @property
    def deeper(self):
        "Going deeper"
        return Lo(self.x, verbose=False, plain=False, depth=1, color=self.color)

    @property
    def rgb(self):
        "Show an image"
        return RGBProxy(self.x)

    @property
    def chans(self):
        "Show color channels"
        return ChanProxy(self.x)

    @property
    def plt(self):
        return PlotProxy(self.x)

    # This is used for .deeper attribute and .deeper(depth=...).
    # The second one results in a __call__.
    def __call__(self, depth=1):
        return Lo(self.x, depth=depth, color=self.color)

# %% ../nbs/10_lo.ipynb 5
def lo(x: Union[np.ndarray, np.generic],    # Your data
        plain   :bool   =False, # Show as plain text - values only
        verbose :bool   =False, # Verbose - show values too
        depth   :int    =0,     # Expand up to `depth`
        color   :O[bool]=None): # Use ANSI colors
    return Lo(x, plain=plain, verbose=verbose, depth=depth, color=color)
