# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class StatementLineResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "statement_line_id": "str",
        "posted_date": "datetime",
        "reference": "str",
        "notes": "str",
        "cheque_no": "str",
        "amount": "float",
        "transaction_date": "datetime",
        "type": "str",
        "is_reconciled": "bool",
        "is_duplicate": "bool",
        "is_deleted": "bool",
        "payments": "list[PaymentResponse]",
        "bank_transactions": "list[BankTransactionResponse]",
    }

    attribute_map = {
        "statement_line_id": "statementLineId",
        "posted_date": "postedDate",
        "reference": "reference",
        "notes": "notes",
        "cheque_no": "chequeNo",
        "amount": "amount",
        "transaction_date": "transactionDate",
        "type": "type",
        "is_reconciled": "isReconciled",
        "is_duplicate": "isDuplicate",
        "is_deleted": "isDeleted",
        "payments": "payments",
        "bank_transactions": "bankTransactions",
    }

    def __init__(
        self,
        statement_line_id=None,
        posted_date=None,
        reference=None,
        notes=None,
        cheque_no=None,
        amount=None,
        transaction_date=None,
        type=None,
        is_reconciled=None,
        is_duplicate=None,
        is_deleted=None,
        payments=None,
        bank_transactions=None,
    ):  # noqa: E501
        """StatementLineResponse - a model defined in OpenAPI"""  # noqa: E501

        self._statement_line_id = None
        self._posted_date = None
        self._reference = None
        self._notes = None
        self._cheque_no = None
        self._amount = None
        self._transaction_date = None
        self._type = None
        self._is_reconciled = None
        self._is_duplicate = None
        self._is_deleted = None
        self._payments = None
        self._bank_transactions = None
        self.discriminator = None

        if statement_line_id is not None:
            self.statement_line_id = statement_line_id
        if posted_date is not None:
            self.posted_date = posted_date
        if reference is not None:
            self.reference = reference
        if notes is not None:
            self.notes = notes
        if cheque_no is not None:
            self.cheque_no = cheque_no
        if amount is not None:
            self.amount = amount
        if transaction_date is not None:
            self.transaction_date = transaction_date
        if type is not None:
            self.type = type
        if is_reconciled is not None:
            self.is_reconciled = is_reconciled
        if is_duplicate is not None:
            self.is_duplicate = is_duplicate
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if payments is not None:
            self.payments = payments
        if bank_transactions is not None:
            self.bank_transactions = bank_transactions

    @property
    def statement_line_id(self):
        """Gets the statement_line_id of this StatementLineResponse.  # noqa: E501

        Xero Identifier of statement line  # noqa: E501

        :return: The statement_line_id of this StatementLineResponse.  # noqa: E501
        :rtype: str
        """
        return self._statement_line_id

    @statement_line_id.setter
    def statement_line_id(self, statement_line_id):
        """Sets the statement_line_id of this StatementLineResponse.

        Xero Identifier of statement line  # noqa: E501

        :param statement_line_id: The statement_line_id of this StatementLineResponse.  # noqa: E501
        :type: str
        """

        self._statement_line_id = statement_line_id

    @property
    def posted_date(self):
        """Gets the posted_date of this StatementLineResponse.  # noqa: E501

        Date of when statement line was posted  # noqa: E501

        :return: The posted_date of this StatementLineResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this StatementLineResponse.

        Date of when statement line was posted  # noqa: E501

        :param posted_date: The posted_date of this StatementLineResponse.  # noqa: E501
        :type: datetime
        """

        self._posted_date = posted_date

    @property
    def reference(self):
        """Gets the reference of this StatementLineResponse.  # noqa: E501

        Reference description of statement line  # noqa: E501

        :return: The reference of this StatementLineResponse.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this StatementLineResponse.

        Reference description of statement line  # noqa: E501

        :param reference: The reference of this StatementLineResponse.  # noqa: E501
        :type: str
        """

        self._reference = reference

    @property
    def notes(self):
        """Gets the notes of this StatementLineResponse.  # noqa: E501

        Notes description of statement line  # noqa: E501

        :return: The notes of this StatementLineResponse.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this StatementLineResponse.

        Notes description of statement line  # noqa: E501

        :param notes: The notes of this StatementLineResponse.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def cheque_no(self):
        """Gets the cheque_no of this StatementLineResponse.  # noqa: E501

        Cheque number of statement line  # noqa: E501

        :return: The cheque_no of this StatementLineResponse.  # noqa: E501
        :rtype: str
        """
        return self._cheque_no

    @cheque_no.setter
    def cheque_no(self, cheque_no):
        """Sets the cheque_no of this StatementLineResponse.

        Cheque number of statement line  # noqa: E501

        :param cheque_no: The cheque_no of this StatementLineResponse.  # noqa: E501
        :type: str
        """

        self._cheque_no = cheque_no

    @property
    def amount(self):
        """Gets the amount of this StatementLineResponse.  # noqa: E501

        Amount of statement line  # noqa: E501

        :return: The amount of this StatementLineResponse.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this StatementLineResponse.

        Amount of statement line  # noqa: E501

        :param amount: The amount of this StatementLineResponse.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def transaction_date(self):
        """Gets the transaction_date of this StatementLineResponse.  # noqa: E501

        Transaction date of statement line  # noqa: E501

        :return: The transaction_date of this StatementLineResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._transaction_date

    @transaction_date.setter
    def transaction_date(self, transaction_date):
        """Sets the transaction_date of this StatementLineResponse.

        Transaction date of statement line  # noqa: E501

        :param transaction_date: The transaction_date of this StatementLineResponse.  # noqa: E501
        :type: datetime
        """

        self._transaction_date = transaction_date

    @property
    def type(self):
        """Gets the type of this StatementLineResponse.  # noqa: E501

        Type of statement line  # noqa: E501

        :return: The type of this StatementLineResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this StatementLineResponse.

        Type of statement line  # noqa: E501

        :param type: The type of this StatementLineResponse.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def is_reconciled(self):
        """Gets the is_reconciled of this StatementLineResponse.  # noqa: E501

        Boolean to show if statement line is reconciled  # noqa: E501

        :return: The is_reconciled of this StatementLineResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_reconciled

    @is_reconciled.setter
    def is_reconciled(self, is_reconciled):
        """Sets the is_reconciled of this StatementLineResponse.

        Boolean to show if statement line is reconciled  # noqa: E501

        :param is_reconciled: The is_reconciled of this StatementLineResponse.  # noqa: E501
        :type: bool
        """

        self._is_reconciled = is_reconciled

    @property
    def is_duplicate(self):
        """Gets the is_duplicate of this StatementLineResponse.  # noqa: E501

        Boolean to show if statement line is duplicate  # noqa: E501

        :return: The is_duplicate of this StatementLineResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_duplicate

    @is_duplicate.setter
    def is_duplicate(self, is_duplicate):
        """Sets the is_duplicate of this StatementLineResponse.

        Boolean to show if statement line is duplicate  # noqa: E501

        :param is_duplicate: The is_duplicate of this StatementLineResponse.  # noqa: E501
        :type: bool
        """

        self._is_duplicate = is_duplicate

    @property
    def is_deleted(self):
        """Gets the is_deleted of this StatementLineResponse.  # noqa: E501

        Boolean to show if statement line is deleted  # noqa: E501

        :return: The is_deleted of this StatementLineResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_deleted

    @is_deleted.setter
    def is_deleted(self, is_deleted):
        """Sets the is_deleted of this StatementLineResponse.

        Boolean to show if statement line is deleted  # noqa: E501

        :param is_deleted: The is_deleted of this StatementLineResponse.  # noqa: E501
        :type: bool
        """

        self._is_deleted = is_deleted

    @property
    def payments(self):
        """Gets the payments of this StatementLineResponse.  # noqa: E501

        List of payments associated with reconciled statement lines  # noqa: E501

        :return: The payments of this StatementLineResponse.  # noqa: E501
        :rtype: list[PaymentResponse]
        """
        return self._payments

    @payments.setter
    def payments(self, payments):
        """Sets the payments of this StatementLineResponse.

        List of payments associated with reconciled statement lines  # noqa: E501

        :param payments: The payments of this StatementLineResponse.  # noqa: E501
        :type: list[PaymentResponse]
        """

        self._payments = payments

    @property
    def bank_transactions(self):
        """Gets the bank_transactions of this StatementLineResponse.  # noqa: E501

        List of bank transactions associated with reconciled statement lines  # noqa: E501

        :return: The bank_transactions of this StatementLineResponse.  # noqa: E501
        :rtype: list[BankTransactionResponse]
        """
        return self._bank_transactions

    @bank_transactions.setter
    def bank_transactions(self, bank_transactions):
        """Sets the bank_transactions of this StatementLineResponse.

        List of bank transactions associated with reconciled statement lines  # noqa: E501

        :param bank_transactions: The bank_transactions of this StatementLineResponse.  # noqa: E501
        :type: list[BankTransactionResponse]
        """

        self._bank_transactions = bank_transactions
