# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class ProfitAndLossResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "start_date": "date",
        "end_date": "date",
        "net_profit_loss": "float",
        "revenue": "PnlAccountClass",
        "expense": "PnlAccountClass",
    }

    attribute_map = {
        "start_date": "startDate",
        "end_date": "endDate",
        "net_profit_loss": "netProfitLoss",
        "revenue": "revenue",
        "expense": "expense",
    }

    def __init__(
        self,
        start_date=None,
        end_date=None,
        net_profit_loss=None,
        revenue=None,
        expense=None,
    ):  # noqa: E501
        """ProfitAndLossResponse - a model defined in OpenAPI"""  # noqa: E501

        self._start_date = None
        self._end_date = None
        self._net_profit_loss = None
        self._revenue = None
        self._expense = None
        self.discriminator = None

        if start_date is not None:
            self.start_date = start_date
        if end_date is not None:
            self.end_date = end_date
        if net_profit_loss is not None:
            self.net_profit_loss = net_profit_loss
        if revenue is not None:
            self.revenue = revenue
        if expense is not None:
            self.expense = expense

    @property
    def start_date(self):
        """Gets the start_date of this ProfitAndLossResponse.  # noqa: E501

        Start date of the report  # noqa: E501

        :return: The start_date of this ProfitAndLossResponse.  # noqa: E501
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this ProfitAndLossResponse.

        Start date of the report  # noqa: E501

        :param start_date: The start_date of this ProfitAndLossResponse.  # noqa: E501
        :type: date
        """

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this ProfitAndLossResponse.  # noqa: E501

        End date of the report  # noqa: E501

        :return: The end_date of this ProfitAndLossResponse.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this ProfitAndLossResponse.

        End date of the report  # noqa: E501

        :param end_date: The end_date of this ProfitAndLossResponse.  # noqa: E501
        :type: date
        """

        self._end_date = end_date

    @property
    def net_profit_loss(self):
        """Gets the net_profit_loss of this ProfitAndLossResponse.  # noqa: E501

        Net profit loss value  # noqa: E501

        :return: The net_profit_loss of this ProfitAndLossResponse.  # noqa: E501
        :rtype: float
        """
        return self._net_profit_loss

    @net_profit_loss.setter
    def net_profit_loss(self, net_profit_loss):
        """Sets the net_profit_loss of this ProfitAndLossResponse.

        Net profit loss value  # noqa: E501

        :param net_profit_loss: The net_profit_loss of this ProfitAndLossResponse.  # noqa: E501
        :type: float
        """

        self._net_profit_loss = net_profit_loss

    @property
    def revenue(self):
        """Gets the revenue of this ProfitAndLossResponse.  # noqa: E501


        :return: The revenue of this ProfitAndLossResponse.  # noqa: E501
        :rtype: PnlAccountClass
        """
        return self._revenue

    @revenue.setter
    def revenue(self, revenue):
        """Sets the revenue of this ProfitAndLossResponse.


        :param revenue: The revenue of this ProfitAndLossResponse.  # noqa: E501
        :type: PnlAccountClass
        """

        self._revenue = revenue

    @property
    def expense(self):
        """Gets the expense of this ProfitAndLossResponse.  # noqa: E501


        :return: The expense of this ProfitAndLossResponse.  # noqa: E501
        :rtype: PnlAccountClass
        """
        return self._expense

    @expense.setter
    def expense(self, expense):
        """Sets the expense of this ProfitAndLossResponse.


        :param expense: The expense of this ProfitAndLossResponse.  # noqa: E501
        :type: PnlAccountClass
        """

        self._expense = expense
