# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class AccountUsage(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "month": "str",
        "account_id": "str",
        "currency_code": "str",
        "total_received": "float",
        "count_received": "int",
        "total_paid": "float",
        "count_paid": "int",
        "total_manual_journal": "float",
        "count_manual_journal": "int",
        "account_name": "str",
        "reporting_code": "str",
        "reporting_code_name": "str",
        "report_code_updated_date_utc": "datetime",
    }

    attribute_map = {
        "month": "month",
        "account_id": "accountId",
        "currency_code": "currencyCode",
        "total_received": "totalReceived",
        "count_received": "countReceived",
        "total_paid": "totalPaid",
        "count_paid": "countPaid",
        "total_manual_journal": "totalManualJournal",
        "count_manual_journal": "countManualJournal",
        "account_name": "accountName",
        "reporting_code": "reportingCode",
        "reporting_code_name": "reportingCodeName",
        "report_code_updated_date_utc": "reportCodeUpdatedDateUtc",
    }

    def __init__(
        self,
        month=None,
        account_id=None,
        currency_code=None,
        total_received=None,
        count_received=None,
        total_paid=None,
        count_paid=None,
        total_manual_journal=None,
        count_manual_journal=None,
        account_name=None,
        reporting_code=None,
        reporting_code_name=None,
        report_code_updated_date_utc=None,
    ):  # noqa: E501
        """AccountUsage - a model defined in OpenAPI"""  # noqa: E501

        self._month = None
        self._account_id = None
        self._currency_code = None
        self._total_received = None
        self._count_received = None
        self._total_paid = None
        self._count_paid = None
        self._total_manual_journal = None
        self._count_manual_journal = None
        self._account_name = None
        self._reporting_code = None
        self._reporting_code_name = None
        self._report_code_updated_date_utc = None
        self.discriminator = None

        if month is not None:
            self.month = month
        if account_id is not None:
            self.account_id = account_id
        if currency_code is not None:
            self.currency_code = currency_code
        if total_received is not None:
            self.total_received = total_received
        if count_received is not None:
            self.count_received = count_received
        if total_paid is not None:
            self.total_paid = total_paid
        if count_paid is not None:
            self.count_paid = count_paid
        if total_manual_journal is not None:
            self.total_manual_journal = total_manual_journal
        if count_manual_journal is not None:
            self.count_manual_journal = count_manual_journal
        if account_name is not None:
            self.account_name = account_name
        if reporting_code is not None:
            self.reporting_code = reporting_code
        if reporting_code_name is not None:
            self.reporting_code_name = reporting_code_name
        if report_code_updated_date_utc is not None:
            self.report_code_updated_date_utc = report_code_updated_date_utc

    @property
    def month(self):
        """Gets the month of this AccountUsage.  # noqa: E501

        The month this usage item contains data for  # noqa: E501

        :return: The month of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._month

    @month.setter
    def month(self, month):
        """Sets the month of this AccountUsage.

        The month this usage item contains data for  # noqa: E501

        :param month: The month of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._month = month

    @property
    def account_id(self):
        """Gets the account_id of this AccountUsage.  # noqa: E501

        The account this usage item contains data for  # noqa: E501

        :return: The account_id of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AccountUsage.

        The account this usage item contains data for  # noqa: E501

        :param account_id: The account_id of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def currency_code(self):
        """Gets the currency_code of this AccountUsage.  # noqa: E501

        The currency code this usage item contains data for  # noqa: E501

        :return: The currency_code of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this AccountUsage.

        The currency code this usage item contains data for  # noqa: E501

        :param currency_code: The currency_code of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def total_received(self):
        """Gets the total_received of this AccountUsage.  # noqa: E501

        Total received  # noqa: E501

        :return: The total_received of this AccountUsage.  # noqa: E501
        :rtype: float
        """
        return self._total_received

    @total_received.setter
    def total_received(self, total_received):
        """Sets the total_received of this AccountUsage.

        Total received  # noqa: E501

        :param total_received: The total_received of this AccountUsage.  # noqa: E501
        :type: float
        """

        self._total_received = total_received

    @property
    def count_received(self):
        """Gets the count_received of this AccountUsage.  # noqa: E501

        Count of received  # noqa: E501

        :return: The count_received of this AccountUsage.  # noqa: E501
        :rtype: int
        """
        return self._count_received

    @count_received.setter
    def count_received(self, count_received):
        """Sets the count_received of this AccountUsage.

        Count of received  # noqa: E501

        :param count_received: The count_received of this AccountUsage.  # noqa: E501
        :type: int
        """

        self._count_received = count_received

    @property
    def total_paid(self):
        """Gets the total_paid of this AccountUsage.  # noqa: E501

        Total paid  # noqa: E501

        :return: The total_paid of this AccountUsage.  # noqa: E501
        :rtype: float
        """
        return self._total_paid

    @total_paid.setter
    def total_paid(self, total_paid):
        """Sets the total_paid of this AccountUsage.

        Total paid  # noqa: E501

        :param total_paid: The total_paid of this AccountUsage.  # noqa: E501
        :type: float
        """

        self._total_paid = total_paid

    @property
    def count_paid(self):
        """Gets the count_paid of this AccountUsage.  # noqa: E501

        Count of paid  # noqa: E501

        :return: The count_paid of this AccountUsage.  # noqa: E501
        :rtype: int
        """
        return self._count_paid

    @count_paid.setter
    def count_paid(self, count_paid):
        """Sets the count_paid of this AccountUsage.

        Count of paid  # noqa: E501

        :param count_paid: The count_paid of this AccountUsage.  # noqa: E501
        :type: int
        """

        self._count_paid = count_paid

    @property
    def total_manual_journal(self):
        """Gets the total_manual_journal of this AccountUsage.  # noqa: E501

        Total value of manual journals  # noqa: E501

        :return: The total_manual_journal of this AccountUsage.  # noqa: E501
        :rtype: float
        """
        return self._total_manual_journal

    @total_manual_journal.setter
    def total_manual_journal(self, total_manual_journal):
        """Sets the total_manual_journal of this AccountUsage.

        Total value of manual journals  # noqa: E501

        :param total_manual_journal: The total_manual_journal of this AccountUsage.  # noqa: E501
        :type: float
        """

        self._total_manual_journal = total_manual_journal

    @property
    def count_manual_journal(self):
        """Gets the count_manual_journal of this AccountUsage.  # noqa: E501

        Count of manual journals  # noqa: E501

        :return: The count_manual_journal of this AccountUsage.  # noqa: E501
        :rtype: int
        """
        return self._count_manual_journal

    @count_manual_journal.setter
    def count_manual_journal(self, count_manual_journal):
        """Sets the count_manual_journal of this AccountUsage.

        Count of manual journals  # noqa: E501

        :param count_manual_journal: The count_manual_journal of this AccountUsage.  # noqa: E501
        :type: int
        """

        self._count_manual_journal = count_manual_journal

    @property
    def account_name(self):
        """Gets the account_name of this AccountUsage.  # noqa: E501

        The name of the account  # noqa: E501

        :return: The account_name of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._account_name

    @account_name.setter
    def account_name(self, account_name):
        """Sets the account_name of this AccountUsage.

        The name of the account  # noqa: E501

        :param account_name: The account_name of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._account_name = account_name

    @property
    def reporting_code(self):
        """Gets the reporting_code of this AccountUsage.  # noqa: E501

        Shown if set  # noqa: E501

        :return: The reporting_code of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._reporting_code

    @reporting_code.setter
    def reporting_code(self, reporting_code):
        """Sets the reporting_code of this AccountUsage.

        Shown if set  # noqa: E501

        :param reporting_code: The reporting_code of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._reporting_code = reporting_code

    @property
    def reporting_code_name(self):
        """Gets the reporting_code_name of this AccountUsage.  # noqa: E501

        Shown if set  # noqa: E501

        :return: The reporting_code_name of this AccountUsage.  # noqa: E501
        :rtype: str
        """
        return self._reporting_code_name

    @reporting_code_name.setter
    def reporting_code_name(self, reporting_code_name):
        """Sets the reporting_code_name of this AccountUsage.

        Shown if set  # noqa: E501

        :param reporting_code_name: The reporting_code_name of this AccountUsage.  # noqa: E501
        :type: str
        """

        self._reporting_code_name = reporting_code_name

    @property
    def report_code_updated_date_utc(self):
        """Gets the report_code_updated_date_utc of this AccountUsage.  # noqa: E501

        Last modified date UTC format  # noqa: E501

        :return: The report_code_updated_date_utc of this AccountUsage.  # noqa: E501
        :rtype: datetime
        """
        return self._report_code_updated_date_utc

    @report_code_updated_date_utc.setter
    def report_code_updated_date_utc(self, report_code_updated_date_utc):
        """Sets the report_code_updated_date_utc of this AccountUsage.

        Last modified date UTC format  # noqa: E501

        :param report_code_updated_date_utc: The report_code_updated_date_utc of this AccountUsage.  # noqa: E501
        :type: datetime
        """

        self._report_code_updated_date_utc = report_code_updated_date_utc
