PEP: 8015 Title: Organization of the Python community Author: Victor
Stinner Status: Rejected Type: Informational Content-Type: text/x-rst
Created: 2018-10-04

Abstract
========

This PEP formalizes the current organization of the Python community and
proposes 3 main changes:

-   Formalize the existing concept of \"Python teams\";
-   Give more autonomy to Python teams;
-   Replace the BDFL (Guido van Rossum) with a new \"Python Steering
    Committee\" of 5 members which has limited roles: basically decide
    how decisions are taken, but don\'t take decisions.

PEPs are approved by a PEP delegate or by a vote (reserved to core
developers, need `>= 2/3` majority).

PEP Rejection
=============

PEP 8015 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

Rationale
=========

This PEP describes the organization of the whole Python development
community, from Python users to the Python Steering Committee.
Describing all groups and all roles in the same document helps to make
the organization more consistent.

The number of governance changes is minimized to get a smooth transition
from the old BDFL organization to the new Steering Committee
organization.

One key design of the organization is to avoid decision bottlenecks.
Discussions and decisions are distributed into Python teams where
experts in each topic can be found. The expectation is smoother
discussions on PEPs: fewer people with better knowledge of the topic.

Previously, most decisions have been taken by the Benevolent Dictator
For Life (BDFL), Guido van Rossum. The growing popularity of Python
increased the pressure on a single person. The proposed organization
distributes decisions and responsibilities to reduce the pressure and
avoid wearing any individual down.

To keep most of the decision power within the hands of the community,
the Python Steering Committee has very limited roles. The idea is to
reduce the risk that a group of people or companies \"takes over\" the
Python project through just a couple individuals. The project must
remain autonomous and open to everybody.

The most sensitives PEPs are decided by democracy: a vote reserved to
core developers, see the [PEP process](#pep-process) section below for
the voting method.

Common Guidelines
=================

-   The Python community is open to everyone.
-   Members must respect the [Python Community Code of
    Conduct](https://www.python.org/psf/codeofconduct/) which ensures
    that discussions remain constructive and that everybody feels
    welcomed.
-   Python is and will remain an autonomous project.
-   People with decisions power should reflect the diversity of its
    users and contributors.

Community Organization
======================

Right now, there are different group of people involved in the Python
project. The more involved you are, the more decisions power you get. It
is important that the people acceding to the deepest group are the most
trusted ones.

This PEP formalizes the following groups:

-   Python Users
-   Python Contributors
-   Python Teams Members
-   Python Core Developers
-   Python Steering Committee Members
-   PSF Code of Conduct Workgroup

Python Users
============

This is the largest group: anyone who uses Python.

Python Contributors
===================

Once a Python user sends an email to a Python mailing list, comments on
the Python bug tracker, proposes or reviews a Python change, they become
a Python contributor.

Python Teams
============

Python became too big to work as an unique team anymore, people
naturally have grouped themselves as teams to work more closely on
specific topics, sometimes called \"Special Interest Group\" (SIG).

When enough developers are interested by a specific topic, they can
create a new team. Usually, the main action is to ask the Python
postmaster to create a new \"SIG\" mailing list, but the team can choose
to use a different communication channel.

Team members are Python contributors and Python core developers. The
team is self-organized and is responsible to select who can join the
team and how.

Team members can get the bug triage permission on the team bug tracker
component. The more involved in a team you are, the more decisions power
and responsibilities you get.

A team might become allowed to decide on their own PEPs, but only the
Python Steering Committee can allow that (and it has the power to revoke
it as well). Such a case is exceptional, currently a single team has
such permission: the Packaging Team.

See [Annex: Examples of Python Teams](#annex-examples-of-python-teams).

Python Core Developers
======================

One restricted definition of a core developer is the ability to merge a
change (anywhere in the code) and have the bug triage permission (on all
bug tracker components).

Core developers are developers who are proven to have the required
skills to decide if a change can be approved or must be rejected, but
also (and this is more important) what changes should not be made.
Python has a long history, big constraints on backward compatibility,
high quality standards (ex: changes require new tests). For these
reasons, becoming a core can take several months or longer.

Becoming a core developer means more responsibilities. For example, if a
developer merges a change, they become responsible for regressions and
for the maintenance of that modified code.

Core developers are expected to be exemplary when it comes to the Code
of Conduct. They are encouraged to mentor contributors.

Promote a contributor as core developer
---------------------------------------

Once an existing core developer considers that a contributor is ready to
join the core group, to become a core developer, that core developer
asks the contributor if they would like to become a core developer. If
the contributor is interested in such new responsibilities, a vote is
organized.

The vote is reserved to core developers, is public, and is open for 1
week. Usually the core developer who proposes the promotion has to
describe the work and skills of the candidate in the description of the
vote. A contributor is only promoted if two thirds (`>= 2/3`) of votes
approve (\"+1\") the promotion. Only \"+1\" and \"-1\" votes are
accounted; other votes (ex: null, \"-0\", \"+0.5\") are ignored.

If the candidate is promoted, usually they get a mentor for 1 month to
help them to handle new responsibilities.

If the candidate is not promoted, a new vote can be organized later,
when the candidate gets the missing skills, for example 6 months later.

Python Steering Committee
=========================

The Python Steering Committee is made of the most trusted core
developers since it has the most decision power. The roles of this group
are strictly limited to ensure that Python keeps its autonomy and
remains open.

The Python Steering Committee is composed of 5 members. They are elected
for 3 years and 1/3 is replaced every year (first year: 1, second year:
2, third year: 2). This way, a member will stay for one full Python
release and the committee composition will be updated frequently. A
committee member can be a candidate for the seat they are leaving. There
are no term limits.

Committee members must be Python core developers. It is important that
the members of the committee reflect the diversity of Python\' users and
contributors. A small step to ensure that is to enforce that only 2
members (strictly less than 50% of the 5 members) can work for the same
employer (same company or subsidiaries of the same company).

The size of 5 members has been chosen for the members diversity and to
ensure that the committee can continue to work even if a member becomes
unavailable for an unknown duration.

Python Steering Committee Roles
-------------------------------

Python Steering Committee roles:

-   Decide how a PEP is approved (or rejected or deferred).
-   Grant or revoke permissions to a Python team. For example, allow a
    team to give the bug triage permission (on the team component) to a
    contributor.

To decide how a PEP is approved (or rejected or deferred), there are two
options:

-   The committee elects a PEP delegate (previously known as
    \"BDFL-delegate\"): a core developer who will take the final
    decision for the specific PEP. The committee select the PEP delegate
    who can be proposed by the Python team where the PEP is discussed.
-   The committee can organize a vote on on the PEP, see [PEP
    process](#pep-process) for the vote organization. The committee
    decides when the vote is organized. A vote is preferred for changes
    affecting all Python users, like language changes.

The committee keeps the \"vision\" and consistency of Python. It also
makes sure that important features reach completion. Their ability to
pick PEP delegates is meant to help them to achieve that goal.

Election of Python Steering Committee Members
---------------------------------------------

The vote is organized by the Steering Committee. It is announced 3 weeks
in advance: candidates have to apply during this period. The vote is
reserved to core developers and is open for 1 week. To avoid
self-censorship, the vote uses secret ballots: avoid the risk of
hostility from someone who may get more power (if they get elected).

The vote uses the [Schulze/Beatpath/CSSD
variant](https://en.wikipedia.org/wiki/Schulze_method) of the [Condorcet
method](https://en.wikipedia.org/wiki/Condorcet_method) using an online
service like [Condorcet Internet Voting Service
(CIVS)](https://civs.cs.cornell.edu/). This voting method reduces the
risk of tie. It also produces a ranking of all candidates, needed for
the creation of the committee.

In case of tie, a new vote is organized immediately between candidates
involved in the tie using the same voting method and also during 1 week.
If the second vote leads to a tie again, the current Steering Committee
is responsible to select the elected member(s).

If a committee member steps down, a new vote is organized to replace
them.

If the situation of a committee member changes in a way that no longer
satisfies the committee constraint (ex: they move to the same company as
two other committee members), they have to resign. If the employer of a
member is acquired by the employer of two other members, the member with
the mandate ending earlier has to resign once the acquisition completes.

Election Creating the Python Steering Committee Members
-------------------------------------------------------

To bootstrap the process, 5 members are elected at the committee
creation. The vote follows the same rules than regular committee votes,
except that the election needs 5 members, and the vote is organized by
the PSF Board.

In a council election, if 3 of the top 5 vote-getters work for the same
employer, then whichever of them ranked lowest is disqualified and the
6th-ranking candidate moves up into 5th place; this is repeated until a
valid council is formed.

In case of tie, a second vote is organized immediately between
candidates involved in the tie and following candidates to fill the
remaining seats. The vote follows the same rules as the regular
committee vote. If the second vote still result in a tie, the PSF Board
is responsible to elect members and decide their position in the vote
result.

The order in the vote result must be unique for elected members: \#1 and
\#2 are elected for 3 years, \#2 and \#3 for 2 years, and \#5 for 1
year.

Example of vote result with a tie:

-   A
-   B
-   C
-   D
-   E, F
-   G
-   \...

The first 4 candidates (A, B, C and D) are elected immediately. If E
works for the same employer than two other elected member, F is also
elected. Otherwise, a second vote is organized for the 5th seat between
E and F.

Special Case: Steering Committee Members And PEPs
-------------------------------------------------

A committee member can be a PEP delegate.

A committee member can propose a PEP, but cannot be the PEP delegate of
their own PEP.

When the committee decides that a PEP must be voted, committee members
can vote as they are also core developers, but they don\'t have more
power than other core developer.

PSF Code of Conduct Workgroup
=============================

Charter
-------

The workgroup\'s purpose is to foster a diverse and inclusive Python
community by enforcing the PSF code of conduct, along with providing
guidance and recommendations to the Python community on codes of
conduct, that supports the PSF mission of "ongoing development of
Python-related technology and educational resources".

We work toward this common goal in three ways:

-   Review, revise, and advise on policies relating to the PSF code of
    conducts and other communities that the PSF supports. This includes
    any \#python chat community & python.org email list under PSF
    jurisdiction.
-   Create a standard set of codes of conduct and supporting documents
    for multiple channels of interaction such as, but not limited to,
    conferences, mailing lists, slack/IRC, code repositories, and more.
-   Develop training materials and other processes to support Python
    community organizers in implementing and enforcing the code of
    conduct.

The organization of this workgroup is defined by the [ConductWG
Charter](https://wiki.python.org/psf/ConductWG/Charter).

Special Case: Ban a core developer
----------------------------------

As any other member of the Python community, the PSF Code of Conduct
Workgroup can ban a core developer for a limited amount of time. In this
case, the core developer immediately loses their core developer status.
Core developers are expected to be exemplary when it comes to the Code
of Conduct.

In general, a ban is only the last resort action when all other options
have been exhausted.

At the end of the ban, the developer is allowed to contribute again as a
regular contributor.

If the developer changes their behavior, another core developer can
organize a new vote to propose the developer for promotion to core
developer. The vote follows the same process than for any other Python
contributor.

PEP process
===========

There are 2 main roles on PEPs:

-   PEP Authors
-   PEP Delegate

PEP Authors do their best to write high quality PEP.

The PEP delegate is responsible to help the authors to enhance their PEP
and is the one taking the final decision (accept, reject or defer the
PEP). They can also help to guide the discussion.

If no decision is taken, the authors can propose again the PEP later
(ex: one year later), if possible with new data to motivate the change.
A PEP Delegate can also choose to mark a PEP as \"Deferred\" to not
reject the PEP and encourage to reopen the discussion later.

PEPs specific to a Python team are discussed on the team mailing list.
PEPs impacting all Python developers (like language changes) must be
discussed on the python-dev mailing list.

Vote on a PEP
-------------

When the Python Steering Committee decides that a PEP needs a wider
approval, a vote is organized.

The vote is reserved to core developers, is public, is announced 1 week
in advance, and is open for 1 week. The PEP can still be updated during
the 1 week notice, but must not be modified during the vote. Such vote
happens on the mailing list where the PEP has been discussed. The
committee decides when the vote is organized. The PEP must have been
discussed for a reasonable amount of time before it is put to vote.

A PEP is only approved if two thirds (`>= 2/3`) of votes approve
(\"+1\") the PEP. Only \"+1\" and \"-1\" votes are accounted; other
votes (ex: null, \"-0\", \"+0.5\") are ignored.

A PEP can only be approved or rejected by a vote, not be deferred.

Lack of Decision
================

If a discussion fails to reach a consensus, if the Python Steering
Committee fail to choose a PEP delegate, or if a PEP delegate fails to
take a decision, the obvious risk is that Python fails to evolve.

That\'s fine. Sometimes, doing nothing is the wisest choice.

Change this PEP
===============

The first version of this PEP has been written after Guido van Rossum
decided to resign from his role of BDFL in July 2018. Before this PEP,
the roles of Python community members have never been formalized. It is
difficult to design a perfect organization at the first attempt. This
PEP can be updated in the future to adjust the organization, specify how
to handle corner cases and fix mistakes.

Any change to this PEP must be validated by a vote. The vote is
announced 3 weeks in advance, is reserved to core developers, happens in
public on the python-committers mailing list, and is open for 1 week.
The proposed PEP change can still be updated during the 3 weeks notice,
but must not be modified during the vote.

The change is only approved if four fifths (`>= 4/5`) of votes approve
(\"+1\") the change. Only \"+1\" and \"-1\" votes are accounted; other
votes (ex: null, \"-0\", \"+0.5\") are ignored.

Annex: Summary on votes
=======================

  Vote                  Notice    Open     Ballot    Method
  --------------------- --------- -------- --------- -----------------------------------
  Promote contributor   none      1 week   public    `>= 2/3` majority
  PEP                   1 week    1 week   public    `>= 2/3` majority
  Change this PEP       3 weeks   1 week   public    `>= 4/5` majority
  Steering Committee    3 weeks   1 week   private   Condorcet (Schulze/Beatpath/CSSD)

All these votes are reserved to core developers.

Annex: Examples of Python Teams
===============================

Below are examples of some Python teams (the list will not be kept up to
date in this PEP).

Packaging Team
--------------

The packaging team runs its own PEP category and can approve (or reject)
their own PEPs.

-   Website: [packaging.python.org](https://packaging.python.org/)
-   Mailing list:
    [distutils-sig](https://mail.python.org/mm3/mailman3/lists/distutils-sig.python.org/)
-   Bug tracker component: `Distutils`
-   Example of members: Paul Moore, Nick Coghlan, Donald Stuff
-   Stdlib module: `distutils`
-   Current PEP delegate: Paul Moore

IDLE Team
---------

IDLE is a special case in the Python standard library: it\'s a whole
application, not just a module. For this reason, it has been decided
that the code will be the same in all Python stable branches (whereas
the stdlib diverges in newer stable branches).

-   Bug tracker component: `IDLE`
-   Example of members: Terry Reedy, Cheryl Sabella, Serhiy Storchaka
-   Stdlib module: `idlelib`

Mentorship Team
---------------

Becoming a core developer is long and slow process. Mentorship is an
efficient way to train contributors as future core developers and build
a trust relationship.

-   Websites:
    -   <https://www.python.org/dev/core-mentorship/>
    -   <https://devguide.python.org/>
-   Repository: <https://github.com/python/devguide>
-   Mailing list:
    [core-mentorship](https://www.python.org/dev/core-mentorship/)
    (private archives)
-   Example of members: Guido van Rossum, Carol Willing, Victor Stinner

Note: The group is not responsible to promote core developers.

Documentation Team
------------------

-   Mailing list:
    [doc-sig](https://mail.python.org/mailman/listinfo/doc-sig)
-   Bug tracker component: `Documentation`
-   GitHub tag: `type-doc`
-   Example of members: Julien Palard, INADA Naoki, Raymond Hettinger.

The team also manages documentation translations.

See also the Mentorship team which maintains the \"Devguide\".

Security Team
-------------

-   Website: <https://www.python.org/news/security/>
-   Mailing lists:
    -   `security@python.org` (to report vulnerabilities)
    -   [security-sig](https://mail.python.org/mm3/mailman3/lists/security-sig.python.org/)
        (public list)
-   Stdlib modules: `hashlib`, `secrets` and `ssl`
-   Example of members: Christian Heimes, Benjamin Peterson

The `security@python.org` mailing list is invite-only: only members of
the \"Python Security Response Team\" (PSRT) can read emails and reply;
whereas security-sig is public.

Note: This team rarely proposed PEPs.

Performance Team
----------------

-   Website: <https://speed.python.org/>
-   Mailing list:
    [speed](https://mail.python.org/mm3/mailman3/lists/speed.python.org/)
-   Repositories:
    -   <https://github.com/python/performance>
    -   <https://github.com/tobami/codespeed>
-   Bug tracker type: `Performance`
-   GitHub label: `type-performance`
-   Stdlib module: `cProfile`, `profile`, `pstats` and `timeit`
-   Example of members: Victor Stinner, INADA Naoki, Serhiy Storchaka

Usually PEPs involving performance impact everybody and so are discussed
on the python-dev mailing list, rather than the speed mailing list.

Asynchronous Programming Team
-----------------------------

-   Website: <https://docs.python.org/dev/library/asyncio.html>
-   Mailing list:
    [async-sig](https://mail.python.org/mailman/listinfo/async-sig)
-   Bug tracker component: `asyncio`
-   GitHub label: `expert-asyncio`
-   Stdlib modules: `asyncio` and `contextvars`
-   Example of members: Andrew Sveltov, Yury Selivanov

PEP only modifying `asyncio` and `contextvars` can be discussed on the
async-sig mailing list, whereas changes impacting the Python language
must be discussed on python-dev.

Type Hints Team
---------------

-   Website: <http://mypy-lang.org/>
-   Repository: <https://github.com/python/typing>
-   GitHub label for mypy project:
    [topic-pep-484](https://github.com/python/mypy/labels/topic-pep-484)
-   Stdlib modules: `typing`
-   Example of members: Guido van Rossum, Ivan Levkivskyi, Jukka
    Lehtosalo, Łukasz Langa, Mark Shannon.

Note: There is a backport for Python 3.6 and older, see [typing on
PyPI](https://pypi.org/project/typing/).

Version History
===============

History of this PEP:

-   Version 7: Adjust the Steering Committee
    -   The Steering Committee is now made of 5 people instead of 3.
    -   There are no term limits (instead of a limit of 2 mandates: 6
        years in total).
    -   A committee member can now be a PEP delegate.
-   Version 6: Adjust votes
    -   Specify the Condorcet method: use Schulze/Beatpath/CSSD variant
        to elect Python Steering Committee members. Specify how to deal
        with tie and the constraint on the employers.
    -   Vote on promoting a contributor and on PEPs now requires
        `>= 2/3` rather than `50%+1`.
    -   Vote on changing this PEP now requires `>= 4/5` rather than
        `50%+1`.
    -   Explain how to deal with a company acquisition.
-   Version 5: Election of Python Steering Committee Members uses secret
    ballots
-   Version 4:
    -   Adjust votes: open for 1 week instead of 1 month, and announced
        in advance.
    -   Rename the \"Python Core Board\" to the \"Python Steering
        Committee\";
    -   Clarify that this committee doesn\'t approve PEPs and that
        committee members cannot cumulate more than 2 mandates;
    -   Add the \"Type Hints\" team to the annex.
-   Version 3: Add \"Special Case: Ban a core developer\" and \"How to
    update this PEP\" sections.
-   Version 2: Rename the \"Python board\" to the \"Python Core Board\",
    to avoid confusion with the PSF Board.
-   Version 1: First version posted to python-committers and
    discuss.python.org.

Copyright
=========

This document has been placed in the public domain.
