PEP: 569 Title: Python 3.8 Release Schedule Version: \$Revision\$
Last-Modified: \$Date\$ Author: Łukasz Langa \<<lukasz@python.org>\>
Status: Active Type: Informational Content-Type: text/x-rst Created:
27-Jan-2018 Python-Version: 3.8

Abstract
========

This document describes the development and release schedule for Python
3.8. The schedule primarily concerns itself with PEP-sized items.

Release Manager and Crew
========================

-   3.8 Release Manager: Łukasz Langa
-   Windows installers: Steve Dower
-   Mac installers: Ned Deily
-   Documentation: Julien Palard

3.8 Lifespan
============

3.8 will receive bugfix updates approximately every 2 months for
approximately 18 months. Some time after the release of 3.9.0 final, the
ninth and final 3.8 bugfix update will be released. After that, it is
expected that security updates (source only) will be released until 5
years after the release of 3.8 final, so until approximately October
2024.

Release Schedule
================

3.8 schedule
------------

Actual:

-   3.8 development begins: Monday, 2018-01-29
-   3.8.0 alpha 1: Sunday, 2019-02-03
-   3.8.0 alpha 2: Monday, 2019-02-25
-   3.8.0 alpha 3: Monday, 2019-03-25
-   3.8.0 alpha 4: Monday, 2019-05-06
-   3.8.0 beta 1: Tuesday, 2019-06-04 (No new features beyond this
    point.)
-   3.8.0 beta 2: Monday, 2019-07-04
-   3.8.0 beta 3: Monday, 2019-07-29
-   3.8.0 beta 4: Friday, 2019-08-30
-   3.8.0 candidate 1: Tuesday, 2019-10-01
-   3.8.0 final: Monday, 2019-10-14
-   3.8.1 candidate 1: Tuesday, 2019-12-10
-   3.8.1: Wednesday, 2019-12-18
-   3.8.2 candidate 1: Monday, 2020-02-10
-   3.8.2 candidate 2: Monday, 2020-02-17
-   3.8.2: Monday, 2020-02-24
-   3.8.3rc1: Wednesday, 2020-04-29
-   3.8.3: Wednesday, 2020-05-13
-   3.8.4rc1: Tuesday, 2020-06-30
-   3.8.4: Monday, 2020-07-13
-   3.8.5: Monday, 2020-07-20 (security hotfix)
-   3.8.6rc1: Tuesday, 2020-09-08

Subsequent bugfix releases at a bi-monthly cadence.

Expected:

-   3.8.6: Monday, 2020-09-21
-   3.8.7rc1: Monday, 2020-11-02
-   3.8.7: Monday, 2020-11-16

Features for 3.8
================

Some of the notable features of Python 3.8 include:

-   PEP 570, Positional-only arguments
-   PEP 572, Assignment Expressions
-   PEP 574, Pickle protocol 5 with out-of-band data
-   PEP 578, Runtime audit hooks
-   PEP 587, Python Initialization Configuration
-   PEP 590, Vectorcall: a fast calling protocol for CPython
-   Typing-related: PEP 591 (Final qualifier), PEP 586 (Literal types),
    and PEP 589 (TypedDict)
-   Parallel filesystem cache for compiled bytecode
-   Debug builds share ABI as release builds
-   f-strings support a handy `=` specifier for debugging
-   `continue` is now legal in `finally:` blocks
-   on Windows, the default `asyncio` event loop is now
    `ProactorEventLoop`
-   on macOS, the *spawn* start method is now used by default in
    `multiprocessing`
-   `multiprocessing` can now use shared memory segments to avoid
    pickling costs between processes
-   `typed_ast` is merged back to CPython
-   `LOAD_GLOBAL` is now 40% faster
-   `pickle` now uses Protocol 4 by default, improving performance

There are many other interesting changes, please consult the \"What\'s
New\" page in the documentation for a full list.

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 72 coding: utf-8 End:
