PEP: 537 Title: Python 3.7 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Ned Deily <nad@python.org> Status: Active
Type: Informational Content-Type: text/x-rst Created: 23-Dec-2016
Python-Version: 3.7

Abstract
========

This document describes the development and release schedule for Python
3.7. The schedule primarily concerns itself with PEP-sized items.

.. Small features may be added up to the first beta release. Bugs may be
fixed until the final release, which is planned for 2018-06.

Release Manager and Crew
========================

-   3.7 Release Manager: Ned Deily
-   Windows installers: Steve Dower
-   Mac installers: Ned Deily
-   Documentation: Julien Palard

3.7 Lifespan
============

3.7 will receive
`bugfix updates <https://devguide.python.org/devcycle/#maintenance-branches>`*
approximately every 3 months for about 24 months. Sometime after the
release of 3.8.0 final, a final 3.7 bugfix update will be released.
After that, it is expected that
`security updates <https://devguide.python.org/devcycle/#security-branches>`*
(source only) will be released as needed until 5 years after the release
of 3.7 final, so until approximately 2023-06.

Release Schedule
================

3.7.0 schedule
--------------

-   3.7 development begins: 2016-09-12
-   3.7.0 alpha 1: 2017-09-19
-   3.7.0 alpha 2: 2017-10-17
-   3.7.0 alpha 3: 2017-12-05
-   3.7.0 alpha 4: 2018-01-09
-   3.7.0 beta 1: 2018-01-31 (No new features beyond this point.)
-   3.7.0 beta 2: 2018-02-27
-   3.7.0 beta 3: 2018-03-29
-   3.7.0 beta 4: 2018-05-02
-   3.7.0 beta 5: 2018-05-30
-   3.7.0 candidate 1: 2018-06-12
-   3.7.0 final: 2018-06-27

3.7.1 schedule (first bugfix release)
-------------------------------------

-   3.7.1 candidate 1: 2018-09-26
-   3.7.1 candidate 2: 2018-10-13
-   3.7.1 final: 2018-10-20

3.7.2 schedule
--------------

-   3.7.2 candidate 1: 2018-12-11
-   3.7.2 final: 2018-12-24

3.7.3 schedule
--------------

-   3.7.3 candidate 1: 2019-03-12
-   3.7.3 final: 2019-03-25

3.7.4 schedule
--------------

-   3.7.4 candidate 1: 2019-06-18
-   3.7.4 candidate 2: 2019-07-02
-   3.7.4 final: 2019-07-08

3.7.5 schedule
--------------

-   3.7.5 candidate 1: 2019-10-02
-   3.7.5 final: 2019-10-15

3.7.6 schedule
--------------

-   3.7.6 candidate 1: 2019-12-11
-   3.7.6 final: 2019-12-18

3.7.7 schedule
--------------

-   3.7.7 candidate 1: 2020-03-04
-   3.7.7 final: 2020-03-10

3.7.8 schedule (last bugfix release)
------------------------------------

Last planned release of binaries

-   3.7.8 candidate 1: 2020-06-15
-   3.7.8 final: 2020-06-27

3.7.9 schedule (security/binary release)
----------------------------------------

Security fixes plus updated binary installers to address 3.7.8 issues;
no further binary releases are planned.

-   3.7.9 final: 2020-08-17

3.7.10 and beyond schedule
--------------------------

Security fixes only, as needed, until 2023-06

-   TBD

Features for 3.7
================

Implemented PEPs for 3.7 (as of 3.7.0 beta 1):

-   :pep:`538`, Coercing the legacy C locale to a UTF-8 based locale
-   :pep:`539`, A New C-API for Thread-Local Storage in CPython
-   :pep:`540`, `UTF-8` mode
-   :pep:`552`, Deterministic `pyc`
-   :pep:`553`, Built-in breakpoint()
-   :pep:`557`, Data Classes
-   :pep:`560`, Core support for typing module and generic types
-   :pep:`562`, Module `__getattr__` and `__dir__`
-   :pep:`563`, Postponed Evaluation of Annotations
-   :pep:`564`, Time functions with nanosecond resolution
-   :pep:`565`, Show DeprecationWarning in **main**
-   :pep:`567`, Context Variables

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
