PEP: 398 Title: Python 3.3 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Georg Brandl <georg@python.org> Status:
Final Type: Informational Content-Type: text/x-rst Created: 23-Mar-2011
Python-Version: 3.3

Abstract
========

This document describes the development and release schedule for Python
3.3. The schedule primarily concerns itself with PEP-sized items.

.. Small features may be added up to and including the first beta
release. Bugs may be fixed until the final release, which is planned for
September 2012.

Release Manager and Crew
========================

-   3.3 Release Managers: Georg Brandl, Ned Deily (3.3.7+)
-   Windows installers: Martin v. Löwis
-   Mac installers: Ronald Oussoren/Ned Deily
-   Documentation: Georg Brandl

3.3 Lifespan
============

3.3 will receive bugfix updates approximately every 4-6 months for
approximately 18 months. After the release of 3.4.0 final, a final 3.3
bugfix update will be released. After that, security updates (source
only) will be released until 5 years after the release of 3.3 final,
which will be September 2017.

As of 2017-09-29, Python 3.3.x reached end-of-life status.

Release Schedule
================

3.3.0 schedule
--------------

-   3.3.0 alpha 1: March 5, 2012
-   3.3.0 alpha 2: April 2, 2012
-   3.3.0 alpha 3: May 1, 2012
-   3.3.0 alpha 4: May 31, 2012
-   3.3.0 beta 1: June 27, 2012

(No new features beyond this point.)

-   3.3.0 beta 2: August 12, 2012
-   3.3.0 candidate 1: August 24, 2012
-   3.3.0 candidate 2: September 9, 2012
-   3.3.0 candidate 3: September 24, 2012
-   3.3.0 final: September 29, 2012

.. don't forget to update final date above as well

.. Every release day listed here is the prospective day of tagging the
release; the actual availability of the release for download on
python.org depends on the schedules of the crew.

3.3.1 schedule
--------------

-   3.3.1 candidate 1: March 23, 2013
-   3.3.1 final: April 6, 2013

3.3.2 schedule
--------------

-   3.3.2 final: May 13, 2013

3.3.3 schedule
--------------

-   3.3.3 candidate 1: October 27, 2013
-   3.3.3 candidate 2: November 9, 2013
-   3.3.3 final: November 16, 2013

3.3.4 schedule
--------------

-   3.3.4 candidate 1: January 26, 2014
-   3.3.4 final: February 9, 2014

3.3.5 schedule
--------------

Python 3.3.5 was the last regular maintenance release before 3.3 entered
security-fix only mode.

-   3.3.5 candidate 1: February 22, 2014
-   3.3.5 candidate 2: March 1, 2014
-   3.3.5 final: March 8, 2014

3.3.6 schedule
--------------

Security fixes only

-   3.3.6 candidate 1 (source-only release): October 4, 2014
-   3.3.6 final (source-only release): October 11, 2014

3.3.7 schedule
--------------

Security fixes only

-   3.3.7 candidate 1 (source-only release): September 6, 2017
-   3.3.7 final (source-only release): September 19, 2017

3.3.x end-of-life
-----------------

-   September 29, 2017

Features for 3.3
================

Implemented / Final PEPs:

-   PEP 362: Function Signature Object
-   PEP 380: Syntax for Delegating to a Subgenerator
-   PEP 393: Flexible String Representation
-   PEP 397: Python launcher for Windows
-   PEP 399: Pure Python/C Accelerator Module Compatibility Requirements
-   PEP 405: Python Virtual Environments
-   PEP 409: Suppressing exception context
-   PEP 412: Key-Sharing Dictionary
-   PEP 414: Explicit Unicode Literal for Python 3.3
-   PEP 415: Implement context suppression with exception attributes
-   PEP 417: Including mock in the Standard Library
-   PEP 418: Add monotonic time, performance counter, and process time
    functions
-   PEP 420: Implicit Namespace Packages
-   PEP 421: Adding sys.implementation
-   PEP 3118: Revising the buffer protocol (protocol semantics
    finalised)
-   PEP 3144: IP Address manipulation library
-   PEP 3151: Reworking the OS and IO exception hierarchy
-   PEP 3155: Qualified name for classes and functions

Other final large-scale changes:

-   Addition of the "faulthandler" module
-   Addition of the "lzma" module, and lzma/xz support in tarfile
-   Implementing `__import__` using importlib
-   Addition of the C decimal implementation
-   Switch of Windows build toolchain to VS 2010

Candidate PEPs:

-   None

.. (Note that these are not accepted yet and even if they are, they
might not be finished in time for Python 3.3.)

Other planned large-scale changes:

-   None

Deferred to post-3.3:

-   PEP 395: Qualified Names for Modules
-   PEP 3143: Standard daemon process library
-   PEP 3154: Pickle protocol version 4
-   Breaking out standard library and docs in separate repos
-   Addition of the "packaging" module, deprecating "distutils"
-   Addition of the "regex" module
-   Email version 6
-   A standard event-loop interface (PEP by Jim Fulton pending)

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
