PEP: 356 Title: Python 2.5 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Neal Norwitz, Guido van Rossum, Anthony
Baxter Status: Final Type: Informational Content-Type: text/x-rst
Created: 07-Feb-2006 Python-Version: 2.5 Post-History:

Abstract
========

This document describes the development and release schedule for Python
2.5. The schedule primarily concerns itself with PEP-sized items. Small
features may be added up to and including the first beta release. Bugs
may be fixed until the final release.

There will be at least two alpha releases, two beta releases, and one
release candidate. The release date is planned for 12 September 2006.

Release Manager
===============

-   Anthony Baxter has volunteered to be Release Manager.
-   Martin von Loewis is building the Windows installers,
-   Ronald Oussoren is building the Mac installers,
-   Fred Drake the doc packages and
-   Sean Reifschneider the RPMs.

Release Schedule
================

-   alpha 1: April 5, 2006 \[completed\]
-   alpha 2: April 27, 2006 \[completed\]
-   beta 1: June 20, 2006 \[completed\]
-   beta 2: July 11, 2006 \[completed\]
-   beta 3: August 3, 2006 \[completed\]
-   rc 1: August 17, 2006 \[completed\]
-   rc 2: September 12, 2006 \[completed\]
-   final: September 19, 2006 \[completed\]

Completed features for 2.5
==========================

-   PEP 308: Conditional Expressions
-   PEP 309: Partial Function Application
-   PEP 314: Metadata for Python Software Packages v1.1
-   PEP 328: Absolute/Relative Imports
-   PEP 338: Executing Modules as Scripts
-   PEP 341: Unified try-except/try-finally to try-except-finally
-   PEP 342: Coroutines via Enhanced Generators
-   PEP 343: The "with" Statement (still need updates in Doc/ref and for
    the `contextlib` module)
-   PEP 352: Required Superclass for Exceptions
-   PEP 353: Using `ssize_t` as the index type
-   PEP 357: Allowing Any Object to be Used for Slicing

-   ASCII became the default coding

-   AST-based compiler

-   Access to C AST from Python through new `_ast` module

-   `any()`/`all()` builtin truth functions

New standard library modules:

-   `cProfile` -- suitable for profiling long running applications with
    minimal overhead

-   `ctypes` -- optional component of the windows installer

-   `ElementTree` and `cElementTree` -- by Fredrik Lundh

-   `hashlib` -- adds support for SHA-224, -256, -384, and -512
    (replaces old `md5` and `sha` modules)

-   `msilib` -- for creating MSI files and `bdist_msi` in distutils.

-   `pysqlite`

-   `uuid`

-   `wsgiref`

Other notable features:

-   Added support for reading shadow passwords \[1\]\_

-   Added support for the Unicode 4.1 UCD

-   Added PEP 302 `zipfile`/`__loader__` support to the following
    modules: `warnings`, `linecache`, `inspect`, `traceback`, `site`,
    and `doctest`

-   Added `pybench` Python benchmark suite -- by Marc-Andre Lemburg

-   Add write support for mailboxes from the code in sandbox/mailbox.
    (Owner: A.M. Kuchling. It would still be good if another person
    would take a look at the new code.)

-   Support for building "fat" Mac binaries (Intel and PPC)

-   Add new icons for Windows with the new Python logo?

-   New utilities in `functools` to help write wrapper functions that
    support naive introspection (e.g. having `f.__name__` return the
    original function name).

-   Upgrade `pyexpat` to use expat 2.0.

-   Python core now compiles cleanly with g++

Possible features for 2.5
=========================

Each feature below should implemented prior to beta1 or will require
BDFL approval for inclusion in 2.5.

-   Modules under consideration for inclusion:

-   Add new icons for MacOS and Unix with the new Python logo? (Owner:
    ???) MacOS:
    http://hcs.harvard.edu/\~jrus/python/prettified-py-icons.png

-   Check the various bits of code in `Demo/` all still work, update or
    remove the ones that don't. (Owner: Anthony)

-   All modules in `Modules/` should be updated to be ssize\_t clean.
    (Owner: Neal)

Deferred until 2.6
==================

-   `bdist_deb` in distutils package \[2\]\_

-   `bdist_egg` in distutils package

-   pure python `pgen` module (Owner: Guido)

-   Remove the `fpectl` module?

-   Make everything in `Modules/` build cleanly with g++

Open issues
===========

-   Bugs that need resolving before release, ie, they block release:

    None

-   Bugs deferred until 2.5.1 (or later):

    -   https://bugs.python.org/issue1544279 - `Socket` module is not
        thread-safe
    -   https://bugs.python.org/issue1541420 - tools and demo missing
        from windows
    -   https://bugs.python.org/issue1542451 - crash with continue in
        nested try/finally
    -   https://bugs.python.org/issue1475523 - gettext.py bug (owner:
        Martin v. Loewis)
    -   https://bugs.python.org/issue1467929 - %-formatting and dicts
    -   https://bugs.python.org/issue1446043 - `unicode()` does not
        raise `LookupError`

-   The PEP 302 changes to (at least) `pkgutil`, `runpy` and `pydoc`
    must be documented.

-   `test_zipfile64` takes too long and too much disk space for most of
    the buildbots. How should this be handled? It is currently disabled.

-   should C modules listed in "Undocumented modules" be removed too?
    "timing" (listed as obsolete), "cl" (listed as possibly not
    up-to-date), and "sv" (listed as obsolete hardware specific).

References
==========

.. \[1\] Shadow Password Support Module
https://bugs.python.org/issue579435

.. \[2\] Joe Smith, bdist\_\* to stdlib?
https://mail.python.org/pipermail/python-dev/2006-February/060926.html

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
