PEP: 297 Title: Support for System Upgrades Version: $Revision$
Last-Modified: $Date$ Author: mal\@lemburg.com (Marc-André Lemburg)
Status: Rejected Type: Standards Track Content-Type: text/x-rst Created:
19-Jul-2001 Python-Version: 2.6 Post-History:

Rejection Notice
================

This PEP is rejected for failure to generate significant interest.

Abstract
========

This PEP proposes strategies to allow the Python standard library to be
upgraded in parts without having to reinstall the complete distribution
or having to wait for a new patch level release.

Problem
=======

Python currently does not allow overriding modules or packages in the
standard library per default. Even though this is possible by defining a
`PYTHONPATH` environment variable (the paths defined in this variable
are prepended to the Python standard library path), there is no standard
way of achieving this without changing the configuration.

Since Python's standard library is starting to host packages which are
also available separately, e.g. the distutils, email and PyXML packages,
which can also be installed independently of the Python distribution, it
is desirable to have an option to upgrade these packages without having
to wait for a new patch level release of the Python interpreter to bring
along the changes.

On some occasions, it may also be desirable to update modules of the
standard library without going through the whole Python release cycle,
e.g. in order to provide hot-fixes for security problems.

Proposed Solutions
==================

This PEP proposes two different but not necessarily conflicting
solutions:

1.  Adding a new standard search path to `sys.path`:
    `$stdlibpath/system-packages` just before the `$stdlibpath` entry.
    This complements the already existing entry for site add-ons
    `$stdlibpath/site-packages` which is appended to the `sys.path` at
    interpreter startup time.

    To make use of this new standard location, distutils will need to
    grow support for installing certain packages in
    `$stdlibpath/system-packages` rather than the standard location for
    third-party packages `$stdlibpath/site-packages`.

2.  Tweaking distutils to install directly into `$stdlibpath` for the
    system upgrades rather than into `$stdlibpath/site-packages`.

The first solution has a few advantages over the second:

-   upgrades can be easily identified (just look in
    `$stdlibpath/system-packages`)

-   upgrades can be de-installed without affecting the rest of the
    interpreter installation

-   modules can be virtually removed from packages; this is due to the
    way Python imports packages: once it finds the top-level package
    directory it stay in this directory for all subsequent package
    submodule imports

-   the approach has an overall much cleaner design than the hackish
    install on top of an existing installation approach

The only advantages of the second approach are that the Python
interpreter does not have to changed and that it works with older Python
versions.

Both solutions require changes to distutils. These changes can also be
implemented by package authors, but it would be better to define a
standard way of switching on the proposed behaviour.

Scope
=====

Solution 1: Python 2.6 and up

Solution 2: all Python versions supported by distutils

Credits
=======

None

References
==========

None

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
