PEP: 271 Title: Prefixing sys.path by command line option Version:
$Revision$ Last-Modified: $Date$ Author: fred\@arakne.com (Frédéric B.
Giacometti) Status: Rejected Type: Standards Track Content-Type:
text/x-rst Created: 15-Aug-2001 Python-Version: 2.2 Post-History:

Abstract
========

At present, setting the `PYTHONPATH` environment variable is the only
method for defining additional Python module search directories.

This PEP introduces the '-P' valued option to the python command as an
alternative to `PYTHONPATH`.

Rationale
=========

On Unix::

    python -P $SOMEVALUE

will be equivalent to::

env PYTHONPATH=\$SOMEVALUE python

On Windows 2K::

    python -P %SOMEVALUE%

will (almost) be equivalent to::

set \_\_PYTHONPATH=%PYTHONPATH% && set PYTHONPATH=%SOMEVALUE%\
&& python && set PYTHONPATH=%\_\_PYTHONPATH%

Other Information
=================

This option is equivalent to the 'java -classpath' option.

When to use this option
=======================

This option is intended to ease and make more robust the use of Python
in test or build scripts, for instance.

Reference Implementation
========================

A patch implementing this is available from SourceForge::

    http://sourceforge.net/tracker/download.php?group_id=5470&atid=305470&file_id=6916&aid=429614

with the patch discussion at::

    http://sourceforge.net/tracker/?func=detail&atid=305470&aid=429614&group_id=5470

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
