PEP: 226 Title: Python 2.1 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Jeremy Hylton <jeremy@alum.mit.edu>
Status: Final Type: Informational Content-Type: text/x-rst Created:
16-Oct-2000 Python-Version: 2.1 Post-History:

Abstract
========

This document describes the post Python 2.0 development and release
schedule. According to this schedule, Python 2.1 will be released in
April of 2001. The schedule primarily concerns itself with PEP-size
items. Small bug fixes and changes will occur up until the first beta
release.

Release Schedule
================

Tentative future release dates

\[bugfix release dates go here\]

Past release dates:

-   17-Apr-2001: 2.1 final release
-   15-Apr-2001: 2.1 release candidate 2
-   13-Apr-2001: 2.1 release candidate 1
-   23-Mar-2001: Python 2.1 beta 2 release
-   02-Mar-2001: First 2.1 beta release
-   02-Feb-2001: Python 2.1 alpha 2 release
-   22-Jan-2001: Python 2.1 alpha 1 release
-   16-Oct-2000: Python 2.0 final release

Open issues for Python 2.0 beta 2
=================================

Add a default unit testing framework to the standard library.

Guidelines for making changes for Python 2.1
============================================

The guidelines and schedule will be revised based on discussion in the
python-dev\@python.org mailing list.

The PEP system was instituted late in the Python 2.0 development cycle
and many changes did not follow the process described in PEP 1. The
development process for 2.1, however, will follow the PEP process as
documented.

The first eight weeks following 2.0 final will be the design and review
phase. By the end of this period, any PEP that is proposed for 2.1
should be ready for review. This means that the PEP is written and
discussion has occurred on the python-dev\@python.org and
python-list\@python.org mailing lists.

The next six weeks will be spent reviewing the PEPs and implementing and
testing the accepted PEPs. When this period stops, we will end
consideration of any incomplete PEPs. Near the end of this period, there
will be a feature freeze where any small features not worthy of a PEP
will not be accepted.

Before the final release, we will have six weeks of beta testing and a
release candidate or two.

General guidelines for submitting patches and making changes
============================================================

Use good sense when committing changes. You should know what we mean by
good sense or we wouldn't have given you commit privileges \<0.5 wink\>.
Some specific examples of good sense include:

-   Do whatever the dictator tells you.

-   Discuss any controversial changes on python-dev first. If you get a
    lot of +1 votes and no -1 votes, make the change. If you get a some
    -1 votes, think twice; consider asking Guido what he thinks.

-   If the change is to code you contributed, it probably makes sense
    for you to fix it.

-   If the change affects code someone else wrote, it probably makes
    sense to ask him or her first.

-   You can use the SourceForge (SF) Patch Manager to submit a patch and
    assign it to someone for review.

Any significant new feature must be described in a PEP and approved
before it is checked in.

Any significant code addition, such as a new module or large patch, must
include test cases for the regression test and documentation. A patch
should not be checked in until the tests and documentation are ready.

If you fix a bug, you should write a test case that would have caught
the bug.

If you commit a patch from the SF Patch Manager or fix a bug from the
Jitterbug database, be sure to reference the patch/bug number in the CVS
log message. Also be sure to change the status in the patch manager or
bug database (if you have access to the bug database).

It is not acceptable for any checked in code to cause the regression
test to fail. If a checkin causes a failure, it must be fixed within 24
hours or it will be backed out.

All contributed C code must be ANSI C. If possible check it with two
different compilers, e.g. gcc and MSVC.

All contributed Python code must follow Guido's Python style guide.
http://www.python.org/doc/essays/styleguide.html

It is understood that any code contributed will be released under an
Open Source license. Do not contribute code if it can't be released this
way.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
