/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.FileLocation;
import com.sas.models.FileLocationInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class InputFileType
extends BaseDataType {
    public static final String RB_KEY = "InputFileType.";
    public static final InputFileType DEFAULT_INSTANCE = new InputFileType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof FileLocationInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return new FileLocation((String)inputValue);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "inputFileValueNotValid.ex.txt", inputLocale), inputValue));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((FileLocationInterface)value).getFileLocation();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        return InputFileType.getMacroVariableValuesForFileLocation(macroInfoSource, value, locale);
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_server");
        return extensions;
    }

    public static Map getMacroVariableValuesForFileLocation(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return DEFAULT_INSTANCE.getMacroVariablesForNull(macroInfoSource);
        }
        FileLocationInterface location = (FileLocationInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (location.getFileLocation() != null) {
            map.put(baseMacroVariableName, location.getFileLocation());
        }
        if (location.getServerName() != null) {
            map.put(baseMacroVariableName + "_server", location.getServerName());
        }
        return map;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof FileLocationInterface && retVal == value) {
            FileLocationInterface file = (FileLocationInterface)retVal;
            FileLocation outPut = new FileLocation(file.getServerName(), file.getFileLocation(), file.isDirectory());
            return outPut;
        }
        return retVal;
    }
}

