/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.Credential;
import com.sas.services.connection.LoggerFactory;
import com.sas.services.connection.Request;

@SASScope
public final class ConnectionRequest
extends Request {
    private ConnectionFactoryKernel _connectionFactory;
    private Credential _credential;
    private long _waitMilliseconds;

    private ConnectionRequest(ConnectionFactoryKernel connectionFactory, Credential credential) {
        this.setConnectionFactory(connectionFactory);
        this.setCredential(credential);
        String msgPrefix = ConnectionRequest.formatMessagePrefix(connectionFactory);
        this.setMessagePrefix(msgPrefix);
    }

    public static ConnectionRequest wrap(ConnectionFactoryKernel connectionFactory, Credential credential) {
        ConnectionRequest cxReq = new ConnectionRequest(connectionFactory, credential);
        return cxReq;
    }

    public static ConnectionRequest wrap(ConnectionFactoryKernel connectionFactory, Credential credential, long waitMilliseconds) {
        ConnectionRequest cxReq = ConnectionRequest.wrap(connectionFactory, credential);
        cxReq.setWaitMilliseconds(waitMilliseconds);
        return cxReq;
    }

    public String toString() {
        String[][] nvPairArr = new String[][]{{"credential", this._credential.toString()}, {"waitMilliseconds", Long.toString(this._waitMilliseconds)}};
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }

    protected ConnectionFactoryKernel getFactory() {
        return this._connectionFactory;
    }

    protected Credential getCredential() {
        return this._credential;
    }

    protected long getWaitMilliseconds() {
        return this._waitMilliseconds;
    }

    private void setConnectionFactory(ConnectionFactoryKernel connectionFactory) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null.");
        }
        this._connectionFactory = connectionFactory;
    }

    private void setCredential(Credential credential) {
        if (credential == null) {
            throw new IllegalArgumentException("credential cannot be null.");
        }
        this._credential = credential;
    }

    private void setWaitMilliseconds(long waitMilliseconds) {
        this._waitMilliseconds = waitMilliseconds;
    }

    private static String formatMessagePrefix(ConnectionFactoryKernel connectionFactory) {
        long factoryID = connectionFactory.getKernelID();
        long requestID = connectionFactory.assignRequestID();
        String msgPrefix = LoggerFactory.formatOrderedPair('f', factoryID, 'r', requestID);
        return msgPrefix;
    }
}

