/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class ExecutorServiceThreadPool
extends ThreadPool {
    private ExecutorService _executor;
    private Set<WorkInterface> _workSet;

    public ExecutorServiceThreadPool(ExecutorService executor) {
        this._executor = executor;
        this._workSet = new HashSet<WorkInterface>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDaemon(WorkInterface work) throws WorkException {
        Set<WorkInterface> set = this._workSet;
        synchronized (set) {
            this._workSet.add(work);
        }
        WorkWrapper wrapper = new WorkWrapper(work);
        try {
            this._executor.execute(wrapper);
        }
        catch (RejectedExecutionException ree) {
            throw new WorkException(ree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void term() {
        this._executor.shutdown();
        HashSet<WorkInterface> workSetCopy = new HashSet<WorkInterface>();
        Set<WorkInterface> set = this._workSet;
        synchronized (set) {
            workSetCopy.addAll(this._workSet);
            this._workSet.clear();
        }
        for (WorkInterface work : workSetCopy) {
            work.release();
        }
        super.term();
    }

    private class WorkWrapper
    implements WorkInterface {
        private WorkInterface _work;

        private WorkWrapper(WorkInterface work) {
            this._work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._work.run();
            }
            finally {
                Set set = ExecutorServiceThreadPool.this._workSet;
                synchronized (set) {
                    ExecutorServiceThreadPool.this._workSet.remove(this._work);
                }
            }
        }

        @Override
        public void release() {
            this._work.release();
        }
    }
}

