/// <reference types="node" />
import { RequestOptions } from 'http';
import { Json } from './safe-json-parse';
/** Interface for JS objects that can be used with the SimpleJsonFetcher */
export interface JsonFetcher<ResultType extends Json = Json> {
    fetch: (uri: string, requestOptions?: FetchRequestOptions, data?: Buffer) => Promise<ResultType>;
}
/**
 * Interface for Request Options, that adds one additional option to the Node.js standard RequestOptions,
 * "responseTimeout", with which a timeout can be set within which the response must be received.
 * (Note the "timeout" in the Node.js standard RequestOptions, concerns something else: the socket idle timeout)
 */
declare type FetchRequestOptions = RequestOptions & {
    responseTimeout?: number;
};
/**
 * HTTPS Fetcher for URIs with JSON body
 *
 * @param defaultRequestOptions - The default RequestOptions to use on individual HTTPS requests
 */
export declare class SimpleJsonFetcher implements JsonFetcher {
    defaultRequestOptions: FetchRequestOptions;
    constructor(props?: {
        defaultRequestOptions?: FetchRequestOptions;
    });
    /**
     * Execute a HTTPS request (with 1 immediate retry in case of errors)
     * @param uri - The URI
     * @param requestOptions - The RequestOptions to use
     * @param data - Data to send to the URI (e.g. POST data)
     * @returns - The response as parsed JSON
     */
    fetch<ResultType extends Json>(uri: string, requestOptions?: FetchRequestOptions, data?: Buffer): Promise<ResultType>;
}
/**
 * Execute a HTTPS request
 * @param uri - The URI
 * @param requestOptions - The RequestOptions to use
 * @param data - Data to send to the URI (e.g. POST data)
 * @returns - The response as parsed JSON
 */
export declare function fetchJson<ResultType extends Json>(uri: string, requestOptions?: FetchRequestOptions, data?: Buffer): Promise<ResultType>;
export {};
