![GUI Overview](https://github.com/iblockchaincyberchain/V2rayP/blob/main/readme_pics/gui.jpg)

## Multiplatform Application

It is evaluated on Windows 10, 11 x64 and Linux Ubuntu AMD64 and Mac OS X AMD64.

The software undergoes thorough evaluation across multiple operating systems to ensure its compatibility and performance on various platforms. Specifically, the evaluation process encompasses Windows 10 and Windows 11 in their 64-bit versions, as well as Linux Ubuntu on AMD64 architecture and Mac OS X on AMD64 architecture as well. By conducting comprehensive testing on these operating systems, the development team can identify and address any platform-specific issues, optimize the software's performance, and guarantee a seamless user experience across different environments. This commitment to cross-platform compatibility demonstrates the software's versatility and its ability to cater to a wide range of users, regardless of their preferred operating system.

## Fragmentation

- The application boasts a remarkable feature by providing support for fragmentation (or segmentation) in the SNI (Server Name Indication) handshake. This capability ensures improved security and efficiency during the handshake process. To enable this functionality, users can easily navigate to the "File" menu and access the "Settings" option. Within the settings, they can set the Cloudflare IP, which helps enhance the overall performance and reliability of the application. Furthermore, users can seamlessly integrate the server's configuration by copying and pasting it directly into the application, streamlining the setup process and ensuring a smooth experience for users. With these straightforward steps, users can leverage the app's fragmentation support and enjoy an enhanced level of security and performance during their communication and data exchange activities.

![Fragmentation](https://github.com/iblockchaincyberchain/V2rayP/blob/main/readme_pics/fragmentation.jpg)

## Features

1. **Multiplatform Compatibility:** V2RayP works seamlessly on Windows, Mac, and Linux, providing a unified experience across different operating systems.

2. **Fragmentation Support:** Enjoy improved network performance and stability, even in challenging conditions, with V2RayP's advanced data transmission capabilities.

3. **Multi-threaded Efficiency:** Experience faster data throughput and optimized resource utilization through V2RayP's efficient multi-threaded design.

4. **Enhanced Cross-Platform Flexibility:** Switch between Windows, Mac, and Linux without compromising functionality, making V2RayP a versatile choice for all users.

5. **Robust Encryption and Security:** Protect your privacy and data with V2RayP's advanced encryption techniques, ensuring a secure browsing experience.

6. **Simplified User Experience:** V2RayP offers a user-friendly interface and easy configuration, suitable for both beginners and advanced users.

7. **Active Community and Open-Source:** Join the vibrant V2RayP community, contribute, and customize the open-source project to fit your specific needs.

8. **Regular Updates and Support:** Count on V2RayP's regular updates and ongoing support to stay ahead with reliable and cutting-edge network solutions.

9. **Privacy Protection:** Stay anonymous and shielded from prying eyes while browsing the internet with V2RayP's privacy features.

10. **Improved Network Stability:** Benefit from enhanced network stability and smoother data transmission with V2RayP's advanced features.

## Installing

```bash
python3 -m pip install v2rayp
```

## Execution

```
python3 -m v2rayp
```
## Prequisites in Ubuntu

Before you begin in ubuntu, make sure you have the following packages installed:

- xclip
- python3-tk

If you are using a Debian-based Linux distribution (e.g., Ubuntu), you can install them using `apt-get`:

```bash
sudo apt-get update
sudo apt-get install xclip python3-tk
```
## Program Capability
**Overview**

Welcome to V2RayP, an innovative and robust multiplatform project that brings enhanced functionality to your network communications. This powerful tool serves as a replacement for v2rayn on Windows, while seamlessly extending its capabilities to both Mac and Linux environments. With support for fragmentation and multi-threaded operations, V2RayP ensures a smooth and secure internet experience for users across various platforms.

**Features**

- **Multiplatform Compatibility:** V2RayP is designed to be compatible with multiple operating systems, including Windows, Mac, and Linux, allowing users to enjoy its benefits on their preferred platform.

- **Seamless Substitution for v2rayn:** Say goodbye to platform-specific limitations! V2RayP replaces v2rayn on Windows, offering a unified and consistent experience across all supported operating systems.

- **Fragmentation Support:** With fragmentation capabilities, V2RayP optimizes data transmission, reducing latency and improving overall performance, even in less stable network conditions.

- **Multi-threaded Efficiency:** V2RayP takes advantage of multi-threading to process concurrent tasks efficiently, maximizing resource utilization and delivering faster data throughput.


**Fragmentation**

The application boasts a remarkable feature by providing support for fragmentation (or segmentation) in the SNI (Server Name Indication) handshake. This capability ensures improved security and efficiency during the handshake process. To enable this functionality, users can easily navigate to the "File" menu and access the "Settings" option. Within the settings, they can set the Cloudflare IP, which helps enhance the overall performance and reliability of the application. Furthermore, users can seamlessly integrate the server's configuration by copying and pasting it directly into the application, streamlining the setup process and ensuring a smooth experience for users. With these straightforward steps, users can leverage the app's fragmentation support and enjoy an enhanced level of security and performance during their communication and data exchange activities.



**Benefits**

- **Enhanced Cross-Platform Flexibility:** Enjoy the freedom to switch between Windows, Mac, and Linux without compromising on functionality. V2RayP ensures a seamless experience across different platforms, making it a versatile choice for diverse user needs.

- **Improved Network Stability:** By supporting fragmentation, V2RayP enhances network stability and reliability, ensuring smoother data transmission, even over challenging network environments.

- **Optimized Performance:** The multi-threaded design of V2RayP results in superior performance, providing users with faster browsing speeds and quicker response times, ultimately enhancing productivity and user satisfaction.

- **Simplified User Experience:** With its user-friendly interface and straightforward configuration, V2RayP makes it easy for both beginners and advanced users to manage and customize their network settings effortlessly.

**Security**

- **Robust Encryption:** V2RayP prioritizes user privacy and data security by employing advanced encryption techniques, safeguarding sensitive information from potential threats.

- **Secure Browsing:** With V2RayP, users can confidently browse the internet knowing their data is protected, ensuring a secure online experience.

- **Privacy Protection:** V2RayP respects user privacy and anonymity, offering a reliable shield against prying eyes and ensuring a safe online environment.

**Open-Source and Community**

- **Open-Source Project:** V2RayP is an open-source initiative, allowing developers to collaborate, contribute, and customize the project to suit their specific needs.

- **Active Community:** Join our vibrant community of users and developers to share ideas, report issues, and stay updated on the latest developments. Together, we strive to make V2RayP even more powerful and user-friendly.

- **Regular Updates and Support:** Rest assured, V2RayP is continuously evolving with regular updates and improvements, ensuring it remains a reliable and cutting-edge solution for your network needs.

- **Get Involved:** Whether you're a seasoned developer or a curious enthusiast, there are numerous ways to get involved and support V2RayP. Help us shape the future of secure and efficient network communication!

## Copyright
- All Rights Reserved License

This software and its accompanying documentation are protected by copyright law and international treaties. Unauthorized reproduction, distribution, or modification of this software, in whole or in part, without prior written permission from the copyright holder, is strictly prohibited.

Permission is granted to use this software for personal, non-commercial purposes only, provided that you retain all copyright and other proprietary notices within the source code and any accompanying documentation.

THE SOFTWARE IS PROVIDED "AS IS," WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NONINFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES, OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT, OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


