"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EngineVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * OpenSearch version.
 *
 * @stability stable
 */
class EngineVersion {
    /**
     * @param version engine version identifier
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom ElasticSearch version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static elasticsearch(version) { return new EngineVersion(`Elasticsearch_${version}`); }
    /**
     * Custom OpenSearch version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static openSearch(version) { return new EngineVersion(`OpenSearch_${version}`); }
}
exports.EngineVersion = EngineVersion;
_a = JSII_RTTI_SYMBOL_1;
EngineVersion[_a] = { fqn: "@aws-cdk/aws-opensearchservice.EngineVersion", version: "1.125.0" };
/**
 * AWS Elasticsearch 1.5.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_1_5 = EngineVersion.elasticsearch('1.5');
/**
 * AWS Elasticsearch 2.3.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_2_3 = EngineVersion.elasticsearch('2.3');
/**
 * AWS Elasticsearch 5.1.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_5_1 = EngineVersion.elasticsearch('5.1');
/**
 * AWS Elasticsearch 5.3.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_5_3 = EngineVersion.elasticsearch('5.3');
/**
 * AWS Elasticsearch 5.5.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_5_5 = EngineVersion.elasticsearch('5.5');
/**
 * AWS Elasticsearch 5.6.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_5_6 = EngineVersion.elasticsearch('5.6');
/**
 * AWS Elasticsearch 6.0.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_0 = EngineVersion.elasticsearch('6.0');
/**
 * AWS Elasticsearch 6.2.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_2 = EngineVersion.elasticsearch('6.2');
/**
 * AWS Elasticsearch 6.3.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_3 = EngineVersion.elasticsearch('6.3');
/**
 * AWS Elasticsearch 6.4.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_4 = EngineVersion.elasticsearch('6.4');
/**
 * AWS Elasticsearch 6.5.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_5 = EngineVersion.elasticsearch('6.5');
/**
 * AWS Elasticsearch 6.7.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_7 = EngineVersion.elasticsearch('6.7');
/**
 * AWS Elasticsearch 6.8.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_6_8 = EngineVersion.elasticsearch('6.8');
/**
 * AWS Elasticsearch 7.1.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_1 = EngineVersion.elasticsearch('7.1');
/**
 * AWS Elasticsearch 7.4.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_4 = EngineVersion.elasticsearch('7.4');
/**
 * AWS Elasticsearch 7.7.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_7 = EngineVersion.elasticsearch('7.7');
/**
 * AWS Elasticsearch 7.8.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_8 = EngineVersion.elasticsearch('7.8');
/**
 * AWS Elasticsearch 7.9.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_9 = EngineVersion.elasticsearch('7.9');
/**
 * AWS Elasticsearch 7.10.
 *
 * @stability stable
 */
EngineVersion.ELASTICSEARCH_7_10 = EngineVersion.elasticsearch('7.10');
/**
 * AWS OpenSearch 1.0.
 *
 * @stability stable
 */
EngineVersion.OPENSEARCH_1_0 = EngineVersion.openSearch('1.0');
//# sourceMappingURL=data:application/json;base64,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