"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    RuntimeFamily[RuntimeFamily["JAVA"] = 1] = "JAVA";
    RuntimeFamily[RuntimeFamily["PYTHON"] = 2] = "PYTHON";
    RuntimeFamily[RuntimeFamily["DOTNET_CORE"] = 3] = "DOTNET_CORE";
    RuntimeFamily[RuntimeFamily["GO"] = 4] = "GO";
    RuntimeFamily[RuntimeFamily["RUBY"] = 5] = "RUBY";
    RuntimeFamily[RuntimeFamily["OTHER"] = 6] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 *
 * @stability stable
 */
class Runtime {
    /**
     * @stability stable
     */
    constructor(name, family, props = {}) {
        var _b, _c;
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        const imageName = (_b = props.bundlingDockerImage) !== null && _b !== void 0 ? _b : `public.ecr.aws/sam/build-${name}`;
        this.bundlingDockerImage = core_1.DockerImage.fromRegistry(imageName);
        this.bundlingImage = this.bundlingDockerImage;
        this.supportsCodeGuruProfiling = (_c = props.supportsCodeGuruProfiling) !== null && _c !== void 0 ? _c : false;
        Runtime.ALL.push(this);
    }
    /**
     * @stability stable
     */
    toString() {
        return this.name;
    }
    /**
     * @stability stable
     */
    runtimeEquals(other) {
        return other.name === this.name &&
            other.family === this.family &&
            other.supportsInlineCode === this.supportsInlineCode;
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-lambda.Runtime", version: "1.119.0" };
/**
 * A list of all known `Runtime`'s.
 *
 * @stability stable
 */
Runtime.ALL = new Array();
/**
 * The NodeJS runtime (nodejs) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS = new Runtime('nodejs', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 4.3 runtime (nodejs4.3) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_4_3 = new Runtime('nodejs4.3', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 6.10 runtime (nodejs6.10) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_6_10 = new Runtime('nodejs6.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 8.10 runtime (nodejs8.10) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.NODEJS_8_10 = new Runtime('nodejs8.10', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 10.x runtime (nodejs10.x).
 *
 * @stability stable
 */
Runtime.NODEJS_10_X = new Runtime('nodejs10.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 12.x runtime (nodejs12.x).
 *
 * @stability stable
 */
Runtime.NODEJS_12_X = new Runtime('nodejs12.x', RuntimeFamily.NODEJS, { supportsInlineCode: true });
/**
 * The NodeJS 14.x runtime (nodejs14.x).
 *
 * @stability stable
 */
Runtime.NODEJS_14_X = new Runtime('nodejs14.x', RuntimeFamily.NODEJS, { supportsInlineCode: false });
/**
 * The Python 2.7 runtime (python2.7).
 *
 * @stability stable
 */
Runtime.PYTHON_2_7 = new Runtime('python2.7', RuntimeFamily.PYTHON, { supportsInlineCode: true });
/**
 * The Python 3.6 runtime (python3.6).
 *
 * @stability stable
 */
Runtime.PYTHON_3_6 = new Runtime('python3.6', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.7 runtime (python3.7).
 *
 * @stability stable
 */
Runtime.PYTHON_3_7 = new Runtime('python3.7', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Python 3.8 runtime (python3.8).
 *
 * @stability stable
 */
Runtime.PYTHON_3_8 = new Runtime('python3.8', RuntimeFamily.PYTHON, {
    supportsInlineCode: true,
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 runtime (java8).
 *
 * @stability stable
 */
Runtime.JAVA_8 = new Runtime('java8', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 8 Corretto runtime (java8.al2).
 *
 * @stability stable
 */
Runtime.JAVA_8_CORRETTO = new Runtime('java8.al2', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The Java 11 runtime (java11).
 *
 * @stability stable
 */
Runtime.JAVA_11 = new Runtime('java11', RuntimeFamily.JAVA, {
    supportsCodeGuruProfiling: true,
});
/**
 * The .NET Core 1.0 runtime (dotnetcore1.0) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_1 = new Runtime('dotnetcore1.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.0 runtime (dotnetcore2.0) Legacy runtime no longer supported by AWS Lambda.
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_2 = new Runtime('dotnetcore2.0', RuntimeFamily.DOTNET_CORE);
/**
 * The .NET Core 2.1 runtime (dotnetcore2.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_2_1 = new Runtime('dotnetcore2.1', RuntimeFamily.DOTNET_CORE, {
    bundlingDockerImage: 'lambci/lambda:build-dotnetcore2.1',
});
/**
 * The .NET Core 3.1 runtime (dotnetcore3.1).
 *
 * @stability stable
 */
Runtime.DOTNET_CORE_3_1 = new Runtime('dotnetcore3.1', RuntimeFamily.DOTNET_CORE, {
    bundlingDockerImage: 'lambci/lambda:build-dotnetcore3.1',
});
/**
 * The Go 1.x runtime (go1.x).
 *
 * @stability stable
 */
Runtime.GO_1_X = new Runtime('go1.x', RuntimeFamily.GO, {
    bundlingDockerImage: 'lambci/lambda:build-go1.x',
});
/**
 * The Ruby 2.5 runtime (ruby2.5).
 *
 * @stability stable
 */
Runtime.RUBY_2_5 = new Runtime('ruby2.5', RuntimeFamily.RUBY);
/**
 * The Ruby 2.7 runtime (ruby2.7).
 *
 * @stability stable
 */
Runtime.RUBY_2_7 = new Runtime('ruby2.7', RuntimeFamily.RUBY);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED = new Runtime('provided', RuntimeFamily.OTHER);
/**
 * The custom provided runtime (provided).
 *
 * @stability stable
 */
Runtime.PROVIDED_AL2 = new Runtime('provided.al2', RuntimeFamily.OTHER);
/**
 * A special runtime entry to be used when function is using a docker image.
 *
 * @stability stable
 */
Runtime.FROM_IMAGE = new Runtime('FROM_IMAGE');
//# sourceMappingURL=data:application/json;base64,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