# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cloudmage', 'cloudmage.jinjautils']

package_data = \
{'': ['*']}

install_requires = \
['jinja2>=2.11.1,<3.0.0']

setup_kwargs = {
    'name': 'cloudmage-jinjautils',
    'version': '1.0.6',
    'description': 'Quickly and easily define, load, render and write Jinja templates.',
    'long_description': '# CloudMage JinjaUtils Python3 Utility Package\n\n<br/>\n\n![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/banners/cloudmage-nebula-glow.png)\n\n<br/>\n\n![PyTests](https://github.com/TheCloudMage/PyPkgs-JinjaUtils/workflows/PyTests/badge.svg)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![Coverage](https://github.com/TheCloudMage/PyPkgs-JinjaUtils/workflows/Coverage/badge.svg)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[![codecov](https://codecov.io/gh/TheCloudMage/PyPkgs-JinjaUtils/branch/master/graph/badge.svg)](https://codecov.io/gh/TheCloudMage/PyPkgs-JinjaUtils)\n\n<br/><br/>\n\n## Table of Contents\n\n* [Description](#description)\n* [Road Map](#road-map)\n* [Python Version Support](#python-version-support)\n* [Package Installation](#package-installation)\n* [Package Dependencies](#package-dependencies)\n* [JinjaUtils Class](#jinjautils-class)\n  * [JinjaUtils Constructor Arguments](#jinjautils-constructor-arguments)\n  * [JinjaUtils Attributes and Properties](#jinjautils-attributes-and-properties)\n  * [JinjaUtils Available Methods](#jinjautils-available-methods)\n  * [JinjaUtils Class Usage](#jinjautils-class-usage)\n* [ChangeLog](#changelog)\n* [Contacts and Contributions](#contacts-and-contributions)\n\n<br/><br/>\n\n## Description\n\nThis utility package was created to allow quick and easy access method to work with Jinja templates within a python environment. The package will give access to a class that can be imported and instantiated, creating a JinjaUtils instance that will allow the consumer the ability to quickly and easily set jinja options via object properties, load templates including custom templates, render those templates and write the template output to the an output directory/file with little concern around error handling and processing. A few lines of code and a provided template is all that is needed to start producing template driven file creation quickly and easily.\n\n<br/><br/>\n\n## Road Map\n\nBeyond the initial capabilities of this library, new features will be evaluated and could be added with feature requests, or as additional processes that can be simplified are discovered.\n\n<br/><br/>\n\n## Python Version Support\n\nThis library is compatible with Python 3.6 and higher. It may work with earlier versions of Python3 but was not tested against anything earlier then 3.6. As Python 2.x is soon to be end of life, backward compatibility was not taken into consideration.\n\n<br/><br/>\n\n## Package Installation\n\nThis library has been published to [PyPi](https://pypi.org/project/cloudmage-jinjautils/) and can be installed via normal python package manager conventions such as [pip](https://pip.pypa.io/en/stable/) or [poetry](https://pypi.org/project/poetry/).\n\n<br/>\n\n```python\npip3 install cloudmage-jinjautils\n```\n\n<br/><br/>\n\n## Package Dependencies\n\nThis package installs and imports the following python modules during installation:\n\n* jinja2\n  * Template\n  * Environment\n  * FileSystemLoader\n\n<br/>\n\nAdditionally the package takes advantage of the following built in python modules:\n\n* os\n* sys\n* json\n* inspect\n* ntpath\n* shutil\n* datetime\n\n<br/><br/>\n\n## JinjaUtils Class\n\nThe JinjaUtils class has the following described methods, properties and attributes accessable to it upon object instantiation. A few object constructor arguments can be provided at the time that the object is instantiated. Object getter property methods are accessed from the object in standard dot notation `Jinja.verbose, Jinja.template_directory, etc.` and Object settter methods are used by assigning a value to the object property `Jinja.template_directory = \'/path/to/templates`. The class gives the object instance access to the following properties:\n\n<br/>\n\n### JinjaUtils Constructor Arguments\n\n-----\n\n| __[verbose](\'\')__ |  *Enables verbose mode. &nbsp; [[true](\'\')=enable &nbsp; [false](\'\')=disable]* |\n|:------------------|:-------------------------------------------------------------------------------|\n| *required*        | [false](\'\')                                                                    |\n| *type*            | [bool](https://docs.python.org/3/library/stdtypes.html)                        |\n| *default*         | [false](\'\') *(disabled)*                                                       |\n\n<br/>\n\n| __[log](\'\')__ |  *Redirects object standard log messaging to provided log object.* |\n|:--------------|:-------------------------------------------------------------------|\n| *required*    | [false](\'\')                                                        |\n| *type*        | [obj](https://docs.python.org/3/library/stdtypes.html)             |\n| *default*     | [None](\'\') *(log to stdout, stderr if verbose=[true](\'\'))*         |\n\n<br/><br/>\n\n### JinjaUtils Attributes and Properties\n\n-----\n\nThe following attributes/properties are available to an instantiated object instance. Any of the attributes or properties can be accessed with standard object dot notation as in the example: `verbose_mode = JinjaUtils.verbose`\n\n<br/>\n\n| __[verbose](\'\')__ |  *Verbose setting that controls logging level within the object class. &nbsp; [[true](\'\')=enabled, [false](\'\')=disabled]* |\n|:---------------------|:--------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(enabled or disabled)*  |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html) |\n| *instantiated value* | [false](false)                                          |\n\n<br/>\n\n| __[trim_blocks](\'\')__|  *Enables or disables the Jinja trim_blocks setting used when loading templates by the Jinja FileSystemLoader.* |\n|:---------------------|:---------------------------------------------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(enabled or disabled)*                                       |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html)                                      |\n| *instantiated value* | [true](true)                                                                                 |\n\n<br/>\n\n| __[lstrip_blocks](\'\')__ |  *Enables or disables the Jinja lstrip_blocks setting used when loading templates by the Jinja FileSystemLoader.* |\n|:---------------------|:---------------------------------------------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) *(enabled or disabled)*                                       |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html)                                      |\n| *instantiated value* | [true](true)                                                                                 |\n\n<br/>\n\n| __[template_directory](\'\')__ | *Getter property method that returns the string value of the currently configured Jinja template directory* |\n|:---------------------|:---------------------------------------------------------------------------------|\n| *returns*            | Jinja template directory [->](->) `/jinja/templates`                             |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                           |\n| *instantiated value* | [None](\'\')                                                                       |\n\n<br/>\n\n| __[available_templates](\'\')__ | *Returns a list of available template files that have been loaded by the Jinja FileSystemLoader located in the configured template directory that are available for use.* |\n|:---------------------|:--------------------------------------------------------------------------------------------------|\n| *returns*            | List of files available in the loaded template library [->](->) [`"template1.j2"`,`"template2.j2"`|\n| *type*               | [list](https://docs.python.org/3/library/stdtypes.html)                                           |\n| *instantiated value* | [None](\'\')                                                                                        |\n\n<br/>\n\n| __[load](\'\')__       |  *Returns the file name of the currently loaded Jinja template that is ready for rendering* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Loaded template name [->](->) `myFile.j2`                                      |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | [None](\'\')                                                                     |\n\n<br/>\n\n| __[rendered](\'\')__   |  *Returns the currently rendered template object, ready to be written to disk* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Rendered template object                                                       |\n| *type*               | [obj](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | [None](\'\')                                                                     |\n\n<br/>\n\n| __[write](\'\')__      |  *Returns [true](true) or [false](false) depending on if the rendered template was successfully written to disk* |\n|:---------------------|:-----------------------------------------------------------------------------------------------------------------|\n| *returns*            | [true](true) or [false](false) value signaling a valid write or failed write to disk                             |\n| *type*               | [bool](https://docs.python.org/3/library/stdtypes.html)                                                          |\n| *instantiated value* | [true](true) or [false](false) value signaling a valid write or failed write                                     |\n\n<br/>\n\n| __[log](\'\')__  | *The class logger. Will either write directly to stdout, stderr, or to a lob object if passed into the object constructor during object instantiation* |\n|:---------------------|:-------------------------------------------------------------------------------|\n| *returns*            | Log Event Stream                                                               |\n| *type*               | [str](https://docs.python.org/3/library/stdtypes.html)                         |\n| *instantiated value* | *Logs written to stdout, stderr*                                               |\n\n<br/><br/>\n\n### JinjaUtils Available Methods\n\n-----\n\nThe following methods are available to an instantiated object instance. Some of the methods are simply setter methods that run the logic required to discover and then set one of the above instance properties.\n\n<br/><br/>\n\n__[verbose](\'\')__\n\nSetter method for `verbose` property that enables or disables verbose mode\n\n<br/>\n\n| parameter   | type       | required     | arg info                                                              |\n|:-----------:|:----------:|:------------:|:----------------------------------------------------------------------|\n| verbose     | [bool](\'\')  | [true](true) | *[True](\'\') enables verbose logging, &nbsp; [False](\'\') disables it* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\nverbose_setting = JinjaUtils.verbose\n\n# Setter method\nJinjaUtils.verbose = True\n```\n\n<br/><br/>\n\n__[trim_blocks](\'\')__\n\nSetter method for `trim_blocks` property that enables or disables the Jinja trim_blocks option during the construction of the Jinja Environment and template loading process via the Jinja FileSystemLoader.\n\n<br/>\n\n| parameter   | type       | required     | arg info                                                                         |\n|:-----------:|:----------:|:------------:|:---------------------------------------------------------------------------------|\n| trim_blocks | [bool](\'\') | [true](true) | *[True](\'\') enables trim_blocks logging, &nbsp; [False](\'\') disables the option* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\njinja_trim_blocks_setting = JinjaUtils.trim_blocks\n\n# Setter method\nJinjaUtils.trim_blocks = True\n```\n\n<br/><br/>\n\n__[lstrip_blocks](\'\')__\n\nSetter method for `lstrip_blocks` property that enables or disables the Jinja lstrip_blocks option during the construction of the Jinja Environment and template loading process via the Jinja FileSystemLoader.\n\n<br/>\n\n| parameter   | type       | required     | arg info                                                                  |\n|:-----------:|:----------:|:------------:|:--------------------------------------------------------------------------|\n| lstrip_blocks | [bool](\'\') | [true](true) | *[True](\'\') enables lstrip_blocks logging, &nbsp; [False](\'\') disables the option* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\njinja_lstrip_blocks = JinjaUtils.lstrip_blocks\n\n# Setter method\nJinjaUtils.lstrip_blocks = True\n```\n\n<br/><br/>\n\n__[template_directory](\'\')__\n\nSetter method for `template_directory` property that is used to specify the location of the Jinja template directory. When this setter method is called, a valid directory path must be provided. The directory path is checked by `os.path.exists()` and must be a valid directory location path. The method will search the directory path for any files in the given directory location and automatically instruct the Jinja FileSystemLoader to load the templates into the Environment template library where they can be called by the object consumer at any point to be loaded, rendered and written to on disk. This setter will also set the value of the `.available_templates` attribute.\n\n<br/>\n\n| parameter           | type       | required     | arg info                                                                  |\n|:-------------------:|:----------:|:------------:|:--------------------------------------------------------------------------|\n| template_directory  | [str](\'\')  | [true](true) | *Provided path must be a valid URL directory path.*                       |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\njinja_template_directory = JinjaUtils.template_directory\n\n# Setter method\nJinjaUtils.template_directory = \'/path/to/my/template/directory\'\n```\n\n<br/><br/>\n\n__[load](\'\')__\n\nSetter method for `load` property. When this method is invoked either a file path argument or template name argument must be provided. If a file name argument is given, the loader will search through the templates that are contained in the currently configured template directory and loaded into the current Jinja Environment by the `.template_directory` setter call. To view a list of the available templates a call to the `.available_templates` attribute can be made. If a file system path is provided to the loader, then the loader will search the given file path, and if a valid file is found, it will instruct the loader to load the provided file. Once a file has been loaded by the object, it is ready to be rendered with the `.render` property.\n\n<br/>\n\n| parameter          | type      | required      | arg info                                                                  |\n|:------------------:|:----------:|:------------:|:--------------------------------------------------------------------------|\n| template           | [str](\'\')  | [true](true) | *Template file name located in the templates directory or valid file path to template file.* |\n\n<br/>\n\n__Examples:__\n\n```python\n# Getter method\njinja_loaded_template = JinjaUtils.load\n\n# Setter method\nJinjaUtils.load = \'/path/to/my/template/directory/template.j2\'\n\nfor template in JinjaUtils.available_templates:\n  print(template)\n\nJinjaUtils.load = \'template.j2\'\n```\n\n<br/><br/>\n\n__[render](\'\')__\n\nThe render method takes an undermined number of keyword arguments representing the template variables and objects that will supply the values to those variables respectively when rendering the template. The keyword example formats such as `variables=dictionaryObject`, `people=["tom", "susan", tonya"]` would be mapped to the template at the time of render and made available to the template. In the given examples, the template may require a dictionary named variables that it will iterate through, or a variable named people that is an expected list that it will use to populate template sections. When the `render` method is called, Jinja will attempt to render the currently loaded template and supply any of keyword arguments that were passed as method arguments at the time that the render method was called.\n\n<br/>\n\n| parameter          | type      | required      | arg info                                                                  |\n|:------------------:|:----------:|:------------:|:--------------------------------------------------------------------------|\n| [names](\'\')=names, [values](\'\')=values, [etc](\'\')=4 | [**kwargs](\'\')  | [false](false) | *Currently loaded template will be rendered.* |\n\n<br/>\n\n__Examples:__\n\n```python\nprint(JinjaUtils.load)  # template.j2\n\nJinjaUtils.render(names=names, values=values, etc=4)\n\n# This will render the currently loaded template2.j2 and pass the names, values, and etc values to it\n```\n\n<br/><br/>\n\n__[write](\'\')__\n\nOnce the template has been rendered, it can be written to disk using the `write` method. The write method takes 2 required arguments consisting of the *output directory* and *output file*, along with 1 optional argument to turn file backup off. When the write method is used, it will write the currently rendered template to the output directory specified as the output file name specified. If during the write operation it discovers an existing file with the same name in the target directory, by default instead of just overwriting the file callously, the write method will take a copy of the existing file, strip off the original extention to avoid non unique file name conflicts and write the copy appending an extention in the format of `_YYYYMMDD_HMS.bak`. This timestamp formatted extention will allow easy identification of when the backup of the file was taken. The default file backup feature can be turned off by passing the `backup=False` option to the write command when called. If backup is disabled, then calling the write method will simply just overwrite any existing files in the output directory with the output filename that already exist. Provided output_directory argument value must exist and be valid directory paths, which are validated by `os.path.exists()`, and must not be the path to a file. The provided output_file argument value must be a valid file name, and will be stripped of any trailing path.\n\n<br/>\n\n| parameter          | type      | required        | arg info                                                                           |\n|:-------------------|:---------:|:---------------:|:-----------------------------------------------------------------------------------|\n| output_directory   | str       | [true](true )   | *Must be valid directory path to existing directory.*                              |\n| output_file        | str       | [true](true )   | *Filename only, paths are stripped using only the file basename .*                 |\n| backup             | bool      | [false](false ) | *Bool value to enable or disable existing file backups. __Default=[true](true )__* |\n\n<br/>\n\n__Examples:__\n\n```python\nprint(str(JinjaUtils.rendered))\n\nJinjaUtils.write(output_directory=\'/reports\', output_file=\'monthly_report.yaml\', backup=True)\n```\n\n<br/><br/>\n\n__[log](\'\')__\n\nMethod to enable logging throughout the class. Log messages are sent to the log method providing the log message, the message type being one of `[debug, info, warning, error]`, and finally the function or method id that is automatically derived within the function or method using the python inspect module. If a log object such as a logger or an already instantiated log object instance was passed to the class constructor during the objects instantiation, then all logs will be written to the provided log object. If no log object was provided during instantiation then all `debug`, `info`, and `warning` logs will be written to stdout, while any encountered `error` log entries will be written to stderr. Note that debug or verbose mode needs to be enabled to receive the event log stream.\n\n<br/>\n\n| arg      | type       | required     | arg info                                          |\n|:--------:|:----------:|:------------:|:--------------------------------------------------|\n| log_msg  | [str](\'\')  | [true](true) | *The actual message being sent to the log method* |\n| log_type | [str](\'\')  | [true](true) | *The type of message that is being sent to the log method, one of `[debug, info, warning, error]`*    |\n| log_id   | [str](\'\')  | [true](true) | *A string value identifying the sender method or function, consisting of the method or function name* |\n\n<br/>\n\n__Examples:__\n\n```python\ndef my_function():\n  __function_id = inspect.stack()[0][3]\n  JinjaUtils.log(\n    f"{__function_id} called.",\n    \'info\',\n    __function_id\n  )\n```\n\n<br/><br/>\n\n### JinjaUtils Class Usage\n\n-----\n\nThe following section will show a few examples of how the module can be used to generate documents from available templates quickly and easily.\n\n<br/>\n\n#### Basic Usage\n\n```python\nfrom cloudmage.jinjautils import JinjaUtils\n\n# Set template directory, contains weekly_report.j2, monthly_report.j2, annual_report.j2\njinja_template_path = os.path.join(os.getcwd(), \'templates\')\njinja_output_path = os.path.join(os.getcwd(), \'monthly_reports\')\n\n# Set data variable\nmonthly_sales = {\'week_1\': 15000, \'week_2\': 1000, \'week_3\': 2000, \'week_4\': 2500}\nsales_team = [\'tonya\', \'tom\', \'billy\', \'amanda\']\n\n# Instantiate JinjaUtils Object\nJinja = JinjaUtils()\n\n# Set the template directory, this loads all templates into the Jinja Environment\n# and constructs the available_templates attribute list value\nJinja.template_directory = jinja_template_path\n\nprint(Jinja.available_templates) # prints [\'weekly_report.j2\', \'monthly_report.j2\', \'annual_report.j2\']\n\n# Load one of the available templates\nJinja.load = \'monthly_report.j2\'\n\n# Render the template\nJinja.render(pnl=monthly_sales, team=sales_team)\n\n# Write the rendered template to disk, Backup of existing files is ENABLED by default, so turn it off\nJinja.write(output_directory=jinja_output_path, output_file=\'feb_sales.html\', backup=False)\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Verbose Class Constructor Argument:__](Note) <br/> When instantiating the class an optional `verbose` argument can be provided. The argument expects a bool value of either `True` or `False`. By default verbose is set to False. If `verbose=True` is passed during object instantiation, then debug mode is turned on allowing the class to output DEBUG, INFO, and WARNING messages to stdout, and ERROR messages to stderr.\n\n<br/><br/>\n\n```python\nfrom cloudmage.jinjautils import JinjaUtils\n\n# Instantiate JinjaUtils Object\nJinja = JinjaUtils(verbose=True)\n\n# Load one of the available templates\nJinja.load = \'./templates/annual_sales.j2\'\n\n# Render the template\nJinja.render(total_sales="25,000")\n\n# Write the rendered template to disk\nJinja.write(output_directory=\'.\', output_file=\'2019-sales.yaml\')\n\n# Class DEBUG, INFO, and WARNING messages will be printed to stdout, and ERROR messages will be printed to stderr\n```\n\n<br/><br/>\n\n> ![CloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/note.png) &nbsp;&nbsp; [__Optional Log Object:__](Note) <br/> When instantiating the class an optional `log` argument can also be provided. The argument expects an Logger object to be passed as an input. If passed then all DEBUG, INFO, WARNING, and ERROR messages will be printed to the standard log levels (`log.debug()`, `log.info()`, `log.warning()`, `log.error()`) and printed to the passed respective logger object method.\n\n<br/><br/>\n\n```python\nfrom cloudmage.jinjautils import JinjaUtils\n\n# Define test log class\n# This is an example log object that simply appends any DEBUG, INFO and ERROR received class messages\n# to the respective log level list. Normally this would be a logger or custom log object.\nclass Log(object):\n        """Test Log Object"""\n\n        def __init__(self):\n            """Class Constructor"""\n            self.debug_logs = []\n            self.info_logs = []\n            self.warning_logs = []\n            self.error_logs = []\n\n        def debug(self, message):\n            """Log Debug Messages"""\n            self.debug_logs.append(message)\n\n        def info(self, message):\n            """Log Info Messages"""\n            self.info_logs.append(message)\n\n        def warning(self, message):\n            """Log Warning Messages"""\n            self.warning_logs.append(message)\n\n        def error(self, message):\n            """Log Error Messages"""\n            self.error_logs.append(message)\n\n# Instantiate test log class\nLogger = Log()\n\n# Instantiate JinjaUtils Object\nJinja = JinjaUtils(verbose=True, logs=Logger)\n\n# Disable trim_blocks, lstrip_blocks\nJinja.trim_blocks = False\nJinja.lstrip_blocks = False\n\n# Load one of the available templates\nJinja.load = \'./templates/team_schedule.j2\'\n\n# Render the template\nJinja.render()\n\n# Write the rendered template to disk\nJinja.write(output_directory=\'/reports\', output_file=\'Feb_Schedule.yaml\', backup=True)\n\nfor items in Logger.debug_logs:\n    print(item) # Prints stored debug logs\n```\n\n<br/><br/>\n\n## Changelog\n\nTo view the project changelog see: [ChangeLog:](CHANGELOG.md)\n\n<br/><br/>\n\n## ![TheCloudMage](https://cloudmage-images-public.s3.us-east-2.amazonaws.com/icons/cloudmage/32/logo.png) &nbsp;&nbsp;Contacts and Contributions\n\nThis project is owned and maintained by: [@TheCloudMage](https://github.com/TheCloudMage)\n\n<br/>\n\nTo contribute, please:\n\n* Fork the project\n* Create a local branch\n* Submit Changes\n* Create A Pull Request\n',
    'author': 'Rich Nason',
    'author_email': 'rnason@cloudmage.io',
    'maintainer': 'Rich Nason',
    'maintainer_email': 'rnason@cloudmage.io',
    'url': 'https://github.com/CloudMages/PyPkgs-JinjaUtils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
