# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class UnitConversionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_unit_conversion(self, unit_conversion_create_dto, **kwargs):  # noqa: E501
        """Create a Unit Conversion  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Unit Conversion.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_unit_conversion(unit_conversion_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitConversionCreateDTO unit_conversion_create_dto: Unit Conversion Create API Model (required)
        :return: UnitConversionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_unit_conversion_with_http_info(unit_conversion_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_unit_conversion_with_http_info(unit_conversion_create_dto, **kwargs)  # noqa: E501
            return data

    def create_unit_conversion_with_http_info(self, unit_conversion_create_dto, **kwargs):  # noqa: E501
        """Create a Unit Conversion  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Unit Conversion.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_unit_conversion_with_http_info(unit_conversion_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitConversionCreateDTO unit_conversion_create_dto: Unit Conversion Create API Model (required)
        :return: UnitConversionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['unit_conversion_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_unit_conversion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'unit_conversion_create_dto' is set
        if ('unit_conversion_create_dto' not in params or
                params['unit_conversion_create_dto'] is None):
            raise ValueError("Missing the required parameter `unit_conversion_create_dto` when calling `create_unit_conversion`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit_conversion_create_dto' in params:
            body_params = params['unit_conversion_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/conversion', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitConversionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_unit_conversion(self, uuid, **kwargs):  # noqa: E501
        """Delete a Unit Conversion by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Unit Conversion by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_unit_conversion(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit Conversion UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_unit_conversion_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_unit_conversion_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_unit_conversion_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Unit Conversion by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Unit Conversion by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_unit_conversion_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit Conversion UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_unit_conversion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_unit_conversion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/conversion/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_unit_conversions(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Unit Conversions  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Unit Conversions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_unit_conversions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UnitConversionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_unit_conversions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_unit_conversions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_unit_conversions_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Unit Conversions  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Unit Conversions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_unit_conversions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UnitConversionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_unit_conversions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/conversion', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UnitConversionDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_unit_conversion_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Unit Conversion by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Unit Conversion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unit_conversion_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit Conversion UUID (required)
        :return: UnitConversionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_unit_conversion_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_unit_conversion_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_unit_conversion_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Unit Conversion by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Unit Conversion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unit_conversion_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Unit Conversion UUID (required)
        :return: UnitConversionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unit_conversion_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_unit_conversion_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/conversion/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnitConversionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_unit_conversions(self, unit_conversion_query_dto, **kwargs):  # noqa: E501
        """Retrieve a List of Unit Conversions by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a List of Unit Conversion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_unit_conversions(unit_conversion_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitConversionQueryDTO unit_conversion_query_dto: Unit Conversion Query API Model (required)
        :return: list[UnitConversionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_unit_conversions_with_http_info(unit_conversion_query_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_unit_conversions_with_http_info(unit_conversion_query_dto, **kwargs)  # noqa: E501
            return data

    def query_unit_conversions_with_http_info(self, unit_conversion_query_dto, **kwargs):  # noqa: E501
        """Retrieve a List of Unit Conversions by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a List of Unit Conversion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_unit_conversions_with_http_info(unit_conversion_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UnitConversionQueryDTO unit_conversion_query_dto: Unit Conversion Query API Model (required)
        :return: list[UnitConversionDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['unit_conversion_query_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_unit_conversions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'unit_conversion_query_dto' is set
        if ('unit_conversion_query_dto' not in params or
                params['unit_conversion_query_dto'] is None):
            raise ValueError("Missing the required parameter `unit_conversion_query_dto` when calling `query_unit_conversions`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unit_conversion_query_dto' in params:
            body_params = params['unit_conversion_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/conversion/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UnitConversionDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
