# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class PhenomenonApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_phenomenon(self, phenomenon_create_dto, **kwargs):  # noqa: E501
        """Create a Phenomenon  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Phenomenon.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_phenomenon(phenomenon_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhenomenonCreateDTO phenomenon_create_dto: The Phenomenon Query (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_phenomenon_with_http_info(phenomenon_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_phenomenon_with_http_info(phenomenon_create_dto, **kwargs)  # noqa: E501
            return data

    def create_phenomenon_with_http_info(self, phenomenon_create_dto, **kwargs):  # noqa: E501
        """Create a Phenomenon  # noqa: E501

        A Spark Works Accounts authenticated user is able to create a Phenomenon.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_phenomenon_with_http_info(phenomenon_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhenomenonCreateDTO phenomenon_create_dto: The Phenomenon Query (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phenomenon_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_phenomenon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'phenomenon_create_dto' is set
        if ('phenomenon_create_dto' not in params or
                params['phenomenon_create_dto'] is None):
            raise ValueError("Missing the required parameter `phenomenon_create_dto` when calling `create_phenomenon`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'phenomenon_create_dto' in params:
            body_params = params['phenomenon_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhenomenonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_phenomenon(self, uuid, **kwargs):  # noqa: E501
        """Delete a Phenomenon by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_phenomenon(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_phenomenon_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_phenomenon_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_phenomenon_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Phenomenon by its UUID  # noqa: E501

        A Spark Works Accounts authenticated user is able to delete a Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_phenomenon_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_phenomenon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_phenomenon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_phenomena(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Phenomenons  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Phenomenons.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_phenomena(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[PhenomenonDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_phenomena_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_phenomena_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_phenomena_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Phenomenons  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve all of the Platform Phenomenons.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_phenomena_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[PhenomenonDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_phenomena" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PhenomenonDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_phenomenon_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Phenomenon by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Phenomenon that has permissions on by its UUID. An administrator is able to get any Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_phenomenon_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_phenomenon_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_phenomenon_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_phenomenon_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Phenomenon by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Phenomenon that has permissions on by its UUID. An administrator is able to get any Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_phenomenon_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_phenomenon_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_phenomenon_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhenomenonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_phenomena(self, phenomenon_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Phenomenon by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Phenomenon.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_phenomena(phenomenon_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhenomenonQueryDTO phenomenon_query_dto: The Phenomenon Query (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_phenomena_with_http_info(phenomenon_query_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.query_phenomena_with_http_info(phenomenon_query_dto, **kwargs)  # noqa: E501
            return data

    def query_phenomena_with_http_info(self, phenomenon_query_dto, **kwargs):  # noqa: E501
        """Retrieve a Phenomenon by a query  # noqa: E501

        A Spark Works Accounts authenticated user is able to retrieve a Phenomenon.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_phenomena_with_http_info(phenomenon_query_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhenomenonQueryDTO phenomenon_query_dto: The Phenomenon Query (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['phenomenon_query_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_phenomena" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'phenomenon_query_dto' is set
        if ('phenomenon_query_dto' not in params or
                params['phenomenon_query_dto'] is None):
            raise ValueError("Missing the required parameter `phenomenon_query_dto` when calling `query_phenomena`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'phenomenon_query_dto' in params:
            body_params = params['phenomenon_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhenomenonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_phenomenon(self, uuid, update_dto, **kwargs):  # noqa: E501
        """Update Phenomenon  # noqa: E501

        A Spark Works Accounts administrator is able to update a Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_phenomenon(uuid, update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :param PhenomenonUpdateDTO update_dto: updateDTO (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_phenomenon_with_http_info(uuid, update_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.update_phenomenon_with_http_info(uuid, update_dto, **kwargs)  # noqa: E501
            return data

    def update_phenomenon_with_http_info(self, uuid, update_dto, **kwargs):  # noqa: E501
        """Update Phenomenon  # noqa: E501

        A Spark Works Accounts administrator is able to update a Phenomenon by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_phenomenon_with_http_info(uuid, update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Phenomenon UUID (required)
        :param PhenomenonUpdateDTO update_dto: updateDTO (required)
        :return: PhenomenonDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'update_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_phenomenon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_phenomenon`")  # noqa: E501
        # verify the required parameter 'update_dto' is set
        if ('update_dto' not in params or
                params['update_dto'] is None):
            raise ValueError("Missing the required parameter `update_dto` when calling `update_phenomenon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_dto' in params:
            body_params = params['update_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/phenomenon/{uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhenomenonDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
