# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class ParticipatorySensingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ps_resource(self, resource_dto, **kwargs):  # noqa: E501
        """Create a Participatory Sensing Resource with an autogenerated uri  # noqa: E501

        Provides means to create a participatory sensing resource and setup its properties in one call, with an autogenerated uri for it  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ps_resource(resource_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AParticipatorySensingResourceRequestAPIModel resource_dto: Resource to be created and used for participatory sensing. (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ps_resource_with_http_info(resource_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ps_resource_with_http_info(resource_dto, **kwargs)  # noqa: E501
            return data

    def create_ps_resource_with_http_info(self, resource_dto, **kwargs):  # noqa: E501
        """Create a Participatory Sensing Resource with an autogenerated uri  # noqa: E501

        Provides means to create a participatory sensing resource and setup its properties in one call, with an autogenerated uri for it  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ps_resource_with_http_info(resource_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AParticipatorySensingResourceRequestAPIModel resource_dto: Resource to be created and used for participatory sensing. (required)
        :return: ResourceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ps_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_dto' is set
        if ('resource_dto' not in params or
                params['resource_dto'] is None):
            raise ValueError("Missing the required parameter `resource_dto` when calling `create_ps_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'resource_dto' in params:
            body_params = params['resource_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/ps/resource', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ps_resource(self, uuid, **kwargs):  # noqa: E501
        """Delete a Participatory Sensing Resource  # noqa: E501

        Provides means to delete a participatory sensing resource   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ps_resource(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Participatory Sensing Resource UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ps_resource_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ps_resource_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_ps_resource_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete a Participatory Sensing Resource  # noqa: E501

        Provides means to delete a participatory sensing resource   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ps_resource_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Participatory Sensing Resource UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ps_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_ps_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/ps/resource/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish_ps_data(self, publish_data_list_dto, **kwargs):  # noqa: E501
        """Publish data to a Participatory Sensing Resource.  # noqa: E501

        Provides means to publish data to a participatory sensing resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_ps_data(publish_data_list_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PublishDataListDTOAPIModel publish_data_list_dto: List of PublishDataDTO to be published to a participatory sensing resource. (required)
        :return: PublishDataListDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_ps_data_with_http_info(publish_data_list_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.publish_ps_data_with_http_info(publish_data_list_dto, **kwargs)  # noqa: E501
            return data

    def publish_ps_data_with_http_info(self, publish_data_list_dto, **kwargs):  # noqa: E501
        """Publish data to a Participatory Sensing Resource.  # noqa: E501

        Provides means to publish data to a participatory sensing resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_ps_data_with_http_info(publish_data_list_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PublishDataListDTOAPIModel publish_data_list_dto: List of PublishDataDTO to be published to a participatory sensing resource. (required)
        :return: PublishDataListDTOAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['publish_data_list_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_ps_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'publish_data_list_dto' is set
        if ('publish_data_list_dto' not in params or
                params['publish_data_list_dto'] is None):
            raise ValueError("Missing the required parameter `publish_data_list_dto` when calling `publish_ps_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'publish_data_list_dto' in params:
            body_params = params['publish_data_list_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/ps/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublishDataListDTOAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
