# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class GroupApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_groups(self, **kwargs):  # noqa: E501
        """Count Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Groups that has permissions on. An administrator is able to retrieve the number of all Groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Count Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Groups that has permissions on. An administrator is able to retrieve the number of all Groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_group(self, group_create_dto, **kwargs):  # noqa: E501
        """Create a new Group  # noqa: E501

        A Spark Works authenticated user is able to request a new Group creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group(group_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateDTO group_create_dto: Group Creation API Model (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_group_with_http_info(group_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_group_with_http_info(group_create_dto, **kwargs)  # noqa: E501
            return data

    def create_group_with_http_info(self, group_create_dto, **kwargs):  # noqa: E501
        """Create a new Group  # noqa: E501

        A Spark Works authenticated user is able to request a new Group creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group_with_http_info(group_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateDTO group_create_dto: Group Creation API Model (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_create_dto' is set
        if ('group_create_dto' not in params or
                params['group_create_dto'] is None):
            raise ValueError("Missing the required parameter `group_create_dto` when calling `create_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_create_dto' in params:
            body_params = params['group_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_group_branch(self, uuid, **kwargs):  # noqa: E501
        """Delete Group branch by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Group branch that has permissions on by its UUID. An administrator is able to remove any Group branch of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_group_branch(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_group_branch_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_group_branch_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_group_branch_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete Group branch by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Group branch that has permissions on by its UUID. An administrator is able to remove any Group branch of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_group_branch_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_group_branch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_group_branch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_groups(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Groups that has permissions on. An administrator is able to query all of the platform Groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Groups that has permissions on. An administrator is able to query all of the platform Groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Group by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Group that has permissions on by its UUID. An administrator is able to get any Group by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_group_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Group by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Group that has permissions on by its UUID. An administrator is able to get any Group by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_group_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_gateways(self, uuid, **kwargs):  # noqa: E501
        """Get the Gateways of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Gateways of Group that has permissions on by its UUID. An administrator is able to retrieve the Gateways of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_gateways(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: list[GatewayDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_gateways_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_gateways_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_group_gateways_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the Gateways of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Gateways of Group that has permissions on by its UUID. An administrator is able to retrieve the Gateways of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_gateways_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: list[GatewayDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_gateways" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_group_gateways`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}/gateway', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GatewayDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_resources(self, uuid, **kwargs):  # noqa: E501
        """Get the Resources of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Resources of Group that has permissions on by its UUID. An administrator is able to retrieve the Resources of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_resources(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_resources_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_resources_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_group_resources_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the Resources of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Resources of Group that has permissions on by its UUID. An administrator is able to retrieve the Resources of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_resources_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_group_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}/resource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ResourceDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_main_level_groups(self, **kwargs):  # noqa: E501
        """List the main level Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to list the Groups of main level that has permissions on. An administrator is able to list all the Groups of main level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_main_level_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_main_level_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_main_level_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_main_level_groups_with_http_info(self, **kwargs):  # noqa: E501
        """List the main level Groups  # noqa: E501

        A Spark Works Accounts authenticated common user is able to list the Groups of main level that has permissions on. An administrator is able to list all the Groups of main level.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_main_level_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_main_level_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/main', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subgroups(self, uuid, depth, **kwargs):  # noqa: E501
        """Get the Subgroups of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Subgroups of Group that has permissions on by its UUID. An administrator is able to retrieve the Subgroups of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subgroups(uuid, depth, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param int depth: depth (required)
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subgroups_with_http_info(uuid, depth, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subgroups_with_http_info(uuid, depth, **kwargs)  # noqa: E501
            return data

    def get_subgroups_with_http_info(self, uuid, depth, **kwargs):  # noqa: E501
        """Get the Subgroups of a Group by the Group UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Subgroups of Group that has permissions on by its UUID. An administrator is able to retrieve the Subgroups of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subgroups_with_http_info(uuid, depth, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param int depth: depth (required)
        :return: list[GroupDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'depth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subgroups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_subgroups`")  # noqa: E501
        # verify the required parameter 'depth' is set
        if ('depth' not in params or
                params['depth'] is None):
            raise ValueError("Missing the required parameter `depth` when calling `get_subgroups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501
        if 'depth' in params:
            path_params['depth'] = params['depth']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}/subgroup/{depth}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_group_branch(self, source_uuid, target_uuid, **kwargs):  # noqa: E501
        """Move Group Branch  # noqa: E501

        A Spark Works Accounts authenticated common user is able to move a Spark Works Group branch that has permissions on under another Group that has permissions on. An administrator is able to move any Group of the platform under any other Group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_group_branch(source_uuid, target_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_uuid: The source Group UUID (required)
        :param str target_uuid: The target Group UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_group_branch_with_http_info(source_uuid, target_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.move_group_branch_with_http_info(source_uuid, target_uuid, **kwargs)  # noqa: E501
            return data

    def move_group_branch_with_http_info(self, source_uuid, target_uuid, **kwargs):  # noqa: E501
        """Move Group Branch  # noqa: E501

        A Spark Works Accounts authenticated common user is able to move a Spark Works Group branch that has permissions on under another Group that has permissions on. An administrator is able to move any Group of the platform under any other Group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_group_branch_with_http_info(source_uuid, target_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_uuid: The source Group UUID (required)
        :param str target_uuid: The target Group UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['source_uuid', 'target_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_group_branch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'source_uuid' is set
        if ('source_uuid' not in params or
                params['source_uuid'] is None):
            raise ValueError("Missing the required parameter `source_uuid` when calling `move_group_branch`")  # noqa: E501
        # verify the required parameter 'target_uuid' is set
        if ('target_uuid' not in params or
                params['target_uuid'] is None):
            raise ValueError("Missing the required parameter `target_uuid` when calling `move_group_branch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'source_uuid' in params:
            path_params['sourceUUID'] = params['source_uuid']  # noqa: E501
        if 'target_uuid' in params:
            path_params['targetUUID'] = params['target_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/move/{sourceUUID}/{targetUUID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_group(self, uuid, group_update_dto, **kwargs):  # noqa: E501
        """Update Group  # noqa: E501

        A Spark Works Accounts authenticated common user is able to update a Group's values that has permission on. An administrator is able to update the values of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_group(uuid, group_update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param GroupUpdateDTO group_update_dto: groupUpdateDTO (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_group_with_http_info(uuid, group_update_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.update_group_with_http_info(uuid, group_update_dto, **kwargs)  # noqa: E501
            return data

    def update_group_with_http_info(self, uuid, group_update_dto, **kwargs):  # noqa: E501
        """Update Group  # noqa: E501

        A Spark Works Accounts authenticated common user is able to update a Group's values that has permission on. An administrator is able to update the values of any Group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_group_with_http_info(uuid, group_update_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Group UUID (required)
        :param GroupUpdateDTO group_update_dto: groupUpdateDTO (required)
        :return: GroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'group_update_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_group`")  # noqa: E501
        # verify the required parameter 'group_update_dto' is set
        if ('group_update_dto' not in params or
                params['group_update_dto'] is None):
            raise ValueError("Missing the required parameter `group_update_dto` when calling `update_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_update_dto' in params:
            body_params = params['group_update_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/group/{uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
