# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class GatewayApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_gateways(self, **kwargs):  # noqa: E501
        """Count Gateways  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Gateways that has permissions on. An administrator is able to retrieve the number of all Gateways.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_gateways(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_gateways_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_gateways_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_gateways_with_http_info(self, **kwargs):  # noqa: E501
        """Count Gateways  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the number of Gateways that has permissions on. An administrator is able to retrieve the number of all Gateways.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_gateways_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_gateways" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_gateway(self, gateway_create_dto, **kwargs):  # noqa: E501
        """Create a new Gateway  # noqa: E501

        A Spark Works authenticated user is able to request a new Gateway creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gateway(gateway_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GatewayCreateDTO gateway_create_dto: Gateway Creation API Model (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_gateway_with_http_info(gateway_create_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.create_gateway_with_http_info(gateway_create_dto, **kwargs)  # noqa: E501
            return data

    def create_gateway_with_http_info(self, gateway_create_dto, **kwargs):  # noqa: E501
        """Create a new Gateway  # noqa: E501

        A Spark Works authenticated user is able to request a new Gateway creation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gateway_with_http_info(gateway_create_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GatewayCreateDTO gateway_create_dto: Gateway Creation API Model (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gateway_create_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gateway" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gateway_create_dto' is set
        if ('gateway_create_dto' not in params or
                params['gateway_create_dto'] is None):
            raise ValueError("Missing the required parameter `gateway_create_dto` when calling `create_gateway`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gateway_create_dto' in params:
            body_params = params['gateway_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GatewayDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_gateway(self, uuid, **kwargs):  # noqa: E501
        """Delete Gateway by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Gateway that has permissions on by its unique identifier. An administrator is able to remove any Gateway of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_gateway(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_gateway_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_gateway_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_gateway_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete Gateway by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to remove a Spark Works Gateway that has permissions on by its unique identifier. An administrator is able to remove any Gateway of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_gateway_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_gateway" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_gateway`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_gateways(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Gateways  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Gateways that has permissions on. An administrator is able to query all of the platform Gateways  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_gateways(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GatewayDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_gateways_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_gateways_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_gateways_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a collection of Gateways  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve all of the Platform Gateways that has permissions on. An administrator is able to query all of the platform Gateways  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_gateways_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[GatewayDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_gateways" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GatewayDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_gateway_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Gateway by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Gateway that has permissions on by its UUID. An administrator is able to get any Gateway by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gateway_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_gateway_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_gateway_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_gateway_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Retrieve a Gateway by its UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Gateway that has permissions on by its UUID. An administrator is able to get any Gateway by its UUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gateway_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gateway_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_gateway_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GatewayDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_gateway_resources(self, uuid, **kwargs):  # noqa: E501
        """Get the Resources of a Gateway by the Gateway UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Resources of Gateway that has permissions on by its UUID. An administrator is able to retrieve the Resources of any Gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gateway_resources(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_gateway_resources_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_gateway_resources_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_gateway_resources_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get the Resources of a Gateway by the Gateway UUID  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve the Resources of Gateway that has permissions on by its UUID. An administrator is able to retrieve the Resources of any Gateway.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gateway_resources_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The Gateway UUID (required)
        :return: list[ResourceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gateway_resources" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_gateway_resources`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway/{uuid}/resource', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ResourceDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_gateways(self, gateway_query, **kwargs):  # noqa: E501
        """Retrieve a Gateway by a query  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Gateway that has permissions on by a query object. An administrator is able to get any Gateway by a query object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_gateways(gateway_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GatewayQueryDTO gateway_query: The Gateway Query (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_gateways_with_http_info(gateway_query, **kwargs)  # noqa: E501
        else:
            (data) = self.query_gateways_with_http_info(gateway_query, **kwargs)  # noqa: E501
            return data

    def query_gateways_with_http_info(self, gateway_query, **kwargs):  # noqa: E501
        """Retrieve a Gateway by a query  # noqa: E501

        A Spark Works Accounts authenticated common user is able to retrieve a Gateway that has permissions on by a query object. An administrator is able to get any Gateway by a query object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_gateways_with_http_info(gateway_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GatewayQueryDTO gateway_query: The Gateway Query (required)
        :return: GatewayDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gateway_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_gateways" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gateway_query' is set
        if ('gateway_query' not in params or
                params['gateway_query'] is None):
            raise ValueError("Missing the required parameter `gateway_query` when calling `query_gateways`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'gateway_query' in params:
            body_params = params['gateway_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/gateway/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GatewayDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
