# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sparkworks_client.api_client import ApiClient


class CommandApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def send_command(self, uuid, command_dto, **kwargs):  # noqa: E501
        """Send a command to a SparkWorks Actuator Resource  # noqa: E501

        A Spark Works Accounts authorized user is able to send a command to a Spark Works Actuator Resource by its unique identifier. An administrator is able to send a command to any Actuator Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_command(uuid, command_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The unique identifier of the Actuator Resource (required)
        :param CommandAPIModel command_dto: commandDto (required)
        :return: CommandAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_command_with_http_info(uuid, command_dto, **kwargs)  # noqa: E501
        else:
            (data) = self.send_command_with_http_info(uuid, command_dto, **kwargs)  # noqa: E501
            return data

    def send_command_with_http_info(self, uuid, command_dto, **kwargs):  # noqa: E501
        """Send a command to a SparkWorks Actuator Resource  # noqa: E501

        A Spark Works Accounts authorized user is able to send a command to a Spark Works Actuator Resource by its unique identifier. An administrator is able to send a command to any Actuator Resource of the platform  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_command_with_http_info(uuid, command_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: The unique identifier of the Actuator Resource (required)
        :param CommandAPIModel command_dto: commandDto (required)
        :return: CommandAPIModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'command_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `send_command`")  # noqa: E501
        # verify the required parameter 'command_dto' is set
        if ('command_dto' not in params or
                params['command_dto'] is None):
            raise ValueError("Missing the required parameter `command_dto` when calling `send_command`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'command_dto' in params:
            body_params = params['command_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/command/{uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommandAPIModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
