# coding: utf-8

"""
    SparkWorks Core API

    Management Service for the SparkWorks Processing Engine  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: info@sparkworks.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from setuptools import setup, find_packages  # noqa: H301
import os
from distutils.command.register import register as register_orig
from distutils.command.upload import upload as upload_orig

NAME = "sparkworksrest"
VERSION = "1.0.14"
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = [
    "certifi>=2017.4.17",
    "python-dateutil>=2.1",
    "six>=1.10",
    "urllib3>=1.23",
    "requests"
]


class register(register_orig):

    def _get_rc_file(self):
        return os.path.join('.', '.pypirc')


class upload(upload_orig):

    def _get_rc_file(self):
        return os.path.join('.', '.pypirc')

with open('README.rst') as f:
    long_description = f.read()

setup(
    name=NAME,
    version=VERSION,
    description="A client library for the sparkworks rest api",
    author_email="info@sparkworks.net",
    url="https://sparkworksnet.github.io/sparkworksrest/",
    keywords=["Swagger", "SparkWorks Core API"],
    install_requires=REQUIRES,
    packages=find_packages(),
    include_package_data=True,
    long_description=long_description,
    cmdclass={
        'register': register,
        'upload': upload,
    }
)
