__author__ = ["Mauro Truglio", "Tommaso Mazza"]
__copyright__ = u"Copyright 2018, The Pyntacle Project"
__credits__ = [u"Ferenc Jordan"]
__version__ = u"1.1"
__maintainer__ = u"Tommaso Mazza"
__email__ = "bioinformatics@css-mendel.it"
__status__ = u"Development"
__date__ = u"26/11/2018"
__license__ = u"""
  Copyright (C) 2016-2020  Tommaso Mazza <t.mazza@css-mendel.it>
  Viale Regina Margherita 261, 00198 Rome, Italy

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <https://www.gnu.org/licenses/>.
  """

import datetime
import logging
import os
import threading
import time
from multiprocessing import cpu_count
from colorama import Fore, Style
from numba import cuda
from numba.core.config import *
from psutil import virtual_memory
import seaborn as sns

log = logging.getLogger(__name__)
logging.basicConfig(level=logging.ERROR, format="%(asctime)s - %(levelname)s - %(message)s")
format_dictionary = {"adjmat": "adjm", "edgelist": "egl", "sif": "sif", "dot": "dot", "bin": "graph", "adjm": "adjm",
                     "graph": "graph", "edgl": "egl", "egl": "egl", "binary": "bin", "adjacencymatrix": "adjm",
                     "edge_list": "egl", "adjacency_matrix": "adjm"}
report_format = {"tsv": "tsv", "txt": "tsv", "csv": "csv", "xlsx": "xlsx", "xlx": "xlsx"}

runtime_date = datetime.datetime.now().strftime("%Y-%m-%d-%H%M%S")

pyntacleink_skip_msg = "Skipping PyntacleInk report\n"

# generic lines
sep_line = Fore.LIGHTGREEN_EX + Style.BRIGHT + u"*" * 100 + "\n" + Style.RESET_ALL
section_end = Fore.RED + Style.BRIGHT + u"*" * 100 + "\n" + Style.RESET_ALL

# dedicated lines
import_start = Fore.RED + Style.BRIGHT + u"*" * 42 + "  FILE IMPORT  " + "*" * 43 + "\n" + Style.RESET_ALL
run_start = Fore.RED + Style.BRIGHT + u"*" * 43 + "  RUN START  " + "*" * 44 + "\n" + Style.RESET_ALL
summary_start = Fore.RED + Style.BRIGHT + u"*" * 42 + "  RUN SUMMARY  " + "*" * 43 + "\n" + Style.RESET_ALL
report_start = Fore.RED + Style.BRIGHT + u"*" * 45 + "  REPORT  " + "*" * 45 + "\n" + Style.RESET_ALL

# Add system info
n_cpus = cpu_count() - 1  # Leaving one thread out
NUMBA_NUM_THREADS = n_cpus
mem = virtual_memory().total
cuda_avail = cuda.is_available()
threadsperblock = 32

sigkill_message = "\nReceived SIGKILL from keyboard\n"


class CursorAnimation(threading.Thread):
    """
    Just a waiting animation, common to several commands.
    """

    def __init__(self):
        self.flag = True

        if os.name == "nt":
            self.animation_char = u"|/-\""
        else:
            self.animation_char = u'⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏'
        self.idx = 0
        threading.Thread.__init__(self)

    def run(self):
        while self.flag:
            sys.stdout.write("Processing...", )
            sys.stdout.write(self.animation_char[self.idx % len(self.animation_char)] + "\r", )
            self.idx += 1
            time.sleep(0.1)

    def stop(self):
        self.flag = False
